package com.digiwin.mobile.mobileuibot.proxy.kbs.serivce.impl;

import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.proxy.kbs.serivce.DigiwinKbsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * 知识中台service
 *
 * @author wuyang
 */
@Service("digiwinKbsService")
public class DigiwinKbsServiceImpl implements DigiwinKbsService {


    @Autowired
    private SysEnvConfig sysEnvConfig;

    @Autowired
    private HttpService httpService;

    @Override
    public Map<String, Object> getInfoBaseHome(Map<String, Object> knowledgeInfos, String iamUserToken, String locale) {
        String url = sysEnvConfig.getKbsUrl() + DigiwinKbsService.API_PREFIX
                + "/knowledge/base/home/info/get";
        Map<String, Object> params = new HashMap<>(1);
        params.put("knowledge_info", knowledgeInfos);
        return getData(url, iamUserToken, params, locale);
    }

    public Map<String, Object> getDetailInfo(Map<String, Object> knowledgeInfos, String iamUserToken, String locale) {
        String url = sysEnvConfig.getKbsUrl() + DigiwinKbsService.API_PREFIX
                + "/knowledge/detail/info/get";
        Map<String, Object> params = new HashMap<>(1);
        params.put("knowledge_info", knowledgeInfos);
        return getData(url, iamUserToken, params, locale);
    }

    public Map<String, Object> getData(String url, String iamUserToken, Map<String, Object> params, String locale) {
        ResponseEntity<Map> responseEntity =
                httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(params), Map.class);
        if (responseEntity != null) {
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                return Collections.emptyMap();
            }
            Map map = (Map) responseEntity.getBody().get("response");
            Map<String, Object> data = (Map<String, Object>) map.get("data");
            if (data != null) {
                return data;
            } else {
                return Collections.emptyMap();
            }
        }
        return null;
    }
}
