package com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Map;

/**
 * 敏捷数据:数据收藏分组返回类
 *
 * @author yanfeng
 * @date 2024/11/27
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class KnowledgeMapsDataCollectionGroupModel implements Serializable {


    /**
     * 分组主键，新增时候不要传此值
     */
    private String groupId;

    /**
     * 分组名称
     */
    private String groupValue;

    /**
     * 类型 user是用户，tenant是租户
     */
    private String type;

    /**
     * 排序
     */
    private Integer orderId;

    /**
     * 租户ID
     */
    private String tenantId;

    /**
     * 用户ID
     */
    private String userId;

    /**
     * 用户名称
     */
    private String userName;

    /**
     * ASACode 兼容融合助理
     */
    private String asaCode;

    /**
     * 语言
     */
    private Map<String, Map<String, String>> language;
}