package com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 敏捷数据:数据收藏返回实体类
 *
 * @author yanfeng
 * @date 2024/6/27
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class KnowledgeMapsDataCollectionModel implements Serializable {

    private static final long serialVersionUID = -386434864876557884L;

    /**
     * 新增的可以为空，已有的看板新增 问题需要带
     */
    private String boardId;

    private String tenantId;

    private String userId;

    private String userName;

    /**
     * 0.单场景消息1.多场景消息2.debug消息3.引用消息 6.指标
     */
    private String agileDataMessageType;

    /**
     * 兼容融合助理,数智助理传空字符
     */
    private String asaCode = "";

    private List<DataCollectQuestion> dataCollectQuestions;

    @Data
    public static class DataCollectQuestion {

        /**
         * 问句
         */
        private String question;

        /**
         * 场景code
         */
        private String sceneCode;

        /**
         * 应用code
         */
        private String appCode;

        /**
         * 指标id列表
         */
        private List<String> metricIdList;

        /**
         * 移动分组的时候需要传groupId,如果是新增收藏时新增的分组可传空串
         */
        private String groupId;

        /**
         * 移动分组的时候需要传groupValue
         */
        private String groupValue;

        /**
         * 类型 user是用户，tenant是租户
         */
        private String groupType;

        /**
         * 数据集id列表
         */
        private List<String> datasetIdList;

        /**
         * 解决步骤(透传)
         */
        private Map<String, Object> solutionStep;

        /**
         * 数据集删除需要传questionId(主键)
         */
        private String questionId;


        /**
         * 显示方式
         */
        private String showType;

        /**
         * 快照id
         */
        private String snapshotId;
    }
}