package com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 敏捷数据-数据订阅实体类
 *
 * @author yanfeng
 * @date 2024/5/24
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class KnowledgeMapsDataSubscriptionModel {

    /**
     * 租户id
     */
    private String tenantId = "";

    /**
     * 新增为空,更新必须传
     * 规则列表 --- KM提供
     */
    private String ruleId = "";

    /**
     * 当是敏捷订阅时填空
     */
    private String actionId = "";

    /**
     * 是否启用排程
     */
    private String enableStatus = "";

    /**
     * 定时任务的来源，默认侦测  agileSubscribe
     */
    private String caller = "";

    /**
     * 排程触发器定义
     */
    private List<Triggers> triggers;

    /**
     * 自定义参数
     */
    private ScheduleParam scheduleParam;

    /**
     * appCode
     */
    private String appCode = "";

    @Data
    public static class Triggers {
        /**
         * 排程频次类型 1指定时间 2周期性执行 3复杂周期性 4重复执行
         */
        private String assign_tim = "";

        /**
         * 单个天
         */
        private String day_radio = "";

        /**
         * 每周的星期几
         */
        private String day_of_week = "";

        /**
         * 当月的第几天
         */
        private String day_of_month = "";

        private String month_radio = "";

        /**
         * 月份放
         */
        private String month = "";

        /**
         * 星期
         */
        private String week_radio = "";

        /**
         * 当月第几周
         */
        private String week_of_month = "";

        private String time_radio = "";

        /**
         * 执行时间
         */
        private String time = "";

        private String time1 = "";
        private String time2 = "";
        private String time3 = "";
    }

    @Data
    public static class ScheduleParam {

        /**
         * 场景code
         */
        private String sceneCode = "";

        /**
         * 问句
         */
        private String question = "";

        /**
         * 用户id
         */
        private String userId = "";

        /**
         * 用户名
         */
        private String userName = "";

        /**
         * 0.单场景消息1.多场景消息2.debug消息3.引用消息
         */
        private String agileDataMessageType = "";

        /**
         * 指标id列表
         */
        private List<String> metricIdList = new ArrayList<>();

        /**
         * 是否是系统级订阅
         */
        private Boolean undeletable = false;

        /**
         * 是否是多对话
         */
        private Boolean multiDialogue;

        /**
         * 助理code
         */
        private String asaCode = "";

        /**
         * 数据集id列表
         */
        private List<String> datasetIdList = new ArrayList<>();

        /**
         * 快照id
         */
        private String snapshotId = "";

        /**
         * 显示方式
         */
        private String showType;

        /**
         * 解决步骤(透传)
         */
        private Map<String, Object> solutionStep;

        /**
         * 条件筛选使用
         */
        private Boolean filterAnalysis;
        private List<Map<String, Object>> stepFilterAnalysis;

        /**
         * 订阅：修改后的标题
         */
        private String chartTitle;

    }
}