package com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.core.component.webview.Webview;
import com.digiwin.mobile.mobileuibot.core.component.webview.WebviewSizeModeEnum;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

/**
 * <p>功能描述：鼎捷雅典娜知识图谱中TBB报表配置参数对象</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: KnowledgeMapsTbbReport
 * @Author: Zaregoto
 * @Date: 2022/6/22 1:17
 */
@Data
@NoArgsConstructor
public class KnowledgeMapsTbbReport implements Serializable {
    private static final long serialVersionUID = 1948660509354966256L;

    private String name;
    private String code;
    private Object groupName;
    private Object groupCode;
    private Object groupSort;
    private Object sort;
    private String category;
    private String appName;
    private String appCode;
    private Object ifCustom;

    public static Webview buildWebview(KnowledgeMapsTbbReport kgTbbReport, String locale, String iamUserToken) throws UnsupportedEncodingException {

        Webview tbbReportWebview = new Webview();

        tbbReportWebview.setSizeMode(WebviewSizeModeEnum.MEDIUM.getMode());
        tbbReportWebview.setTitle(kgTbbReport.getName());
        String url = AppContext.getApiUrlSetting().getTbbWebUrl() + "/#/pages/index?"
                + "locale=" + locale
                + "&mobile_user_token=" + iamUserToken
                + "&dashboardtype=Template"
                + "&dashboardId=" + kgTbbReport.getCode()
                + "&name=" + URLEncoder.encode(kgTbbReport.getName(), "utf-8")
                + "&systemtype=athena";
        tbbReportWebview.setUrl(url);

        return tbbReportWebview;
    }

    /**
     * 图表首页
     *
     * @param kgTbbReport
     * @param locale
     * @param iamUserToken
     * @return
     * @throws UnsupportedEncodingException
     */
    public static Webview buildBoardWebview(KnowledgeMapsTbbReport kgTbbReport, String locale, String iamUserToken) throws UnsupportedEncodingException {

        Webview tbbReportWebview = new Webview();

        tbbReportWebview.setSizeMode(WebviewSizeModeEnum.MEDIUM.getMode());
        tbbReportWebview.setTitle(kgTbbReport.getName());
        String url = AppContext.getApiUrlSetting().getTbbWebUrl() + "/#/pages/board?"
                + "locale=" + locale
                + "&mobile_user_token=" + iamUserToken
                + "&dashboardtype=Template"
                + "&dashboardId=" + kgTbbReport.getCode()
                + "&name=" + URLEncoder.encode(kgTbbReport.getName(), "utf-8")
                + "&systemtype=athena";
        tbbReportWebview.setUrl(url);

        return tbbReportWebview;
    }
}
