package com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.metadata;

import com.alibaba.fastjson.annotation.JSONType;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：鼎捷雅典娜知识图谱保存的行动（Action）元数据对象中的基本元素，即API字段</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: KnowledgeMapsActionMetadataQueryResult
 * @Author: zaregoto
 * @Date: 2023/4/4 14:04
 */
@Data
@NoArgsConstructor
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
@JSONType(naming = com.alibaba.fastjson.PropertyNamingStrategy.SnakeCase)
public class KnowledgeMapsActionMetadataElement implements Serializable {

    private static final long serialVersionUID = -7823609544535777721L;

    /**
     * 当前字段名称
     * eg. user_data
     */
    private String dataName;

    /**
     * 当前字段数据类型
     * eg. object
     */
    private String dataType;

    /**
     * 当前字段是否必要  可能是Boolean，String
     * eg. "true"
     */
    private Object required;

    /**
     * 当前字段是否为数据库主键
     * eg. "true"
     */
    private String isDatakey;

    /**
     * 当前字段是否是数组类型
     */
    private Boolean isArray;

    /**
     * 当前字段是否是业务主键  可能是Boolean，String
     */
    private Object isBusinesskey;

    /**
     * 当前字段描述信息
     */
    private String description;

    /**
     * 当前字段备注信息
     */
    private String remark;

    /**
     * 下层字段
     */
    private List<KnowledgeMapsActionMetadataElement> field;

    /**
     * 当前字段精度
     */
    private Object precision;

    /**
     * 当前字段的枚举key
     */
    private Object enumKey;

    /**
     * 当月字段是否用于排序
     */
    private Boolean canSort;
}