package com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.*;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.*;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.*;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.metadata.KnowledgeMapsActionMetadataQueryResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.PcUiBotTmPageUIElements;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：鼎捷雅典娜知识图谱服务调用类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @author zhangjj
 * @date 2021/10/28 0028 15:14
 */
public interface DigiwinKnowledgeMapsProxyService {

    /**
     * 图谱领域
     */
    String KG_DOMAIN_API_PREFIX = "/restful/service/knowledgegraph";

    /**
     * 敏捷问数agileDataQuery服务地址使用
     */
    String ADQ_API_SUFFIX = "/restful/service/knowledgegraph";

    /**
     * tag领域
     */
    String TAG_DOMAIN_API_PREFIX = "/restful/service/tagsystem";

    /**
     * datamap领域
     */
    String DATAMAP_DOMAIN_API_PREFIX = "/restful/standard/datamap";
    String DATAMAP_API_PREFIX = "/restful/service/datamap";

    /**
     * smartData服务
     */
    String SMARTDATA_PREFIX = "/restful/service";

    /**
     * 获取可发起项目列表
     *
     * @param iamUserToken
     * @param locale
     * @return
     */
    List<KnowledgeMapsProject> getLaunchableProjects(String iamUserToken, String tenantId, String locale);

    /**
     * 获取TBB平台报表资讯
     *
     * @param iamUserToken
     * @param locale
     * @param productCode
     */
    List<KnowledgeMapsTbbReport> getTbbReports(String iamUserToken, String locale, String productCode);

    /**
     * 根据机制参数获取机制参数值
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param variableName 机制参数
     * @return
     */
    Map<String, Object> getMechanismParamValue(String iamUserToken, String tenantId, String locale, String variableName);


    /**
     * 获取机制能力code
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param stringList
     * @return List<Map < String, Object>>
     */
    List<Map<String, Object>> getMechanismCapabilityCode(String iamUserToken, String tenantId, String locale, List<String> stringList);


    /**
     * 制令上线：获取制程主从关系
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param code
     * @return List<Map < String, Object>>
     */
    Map<String, Object> getVariableListSimple(String iamUserToken, String tenantId, String locale, List<String> code);

    /**
     * 根据机制参数list获取机制参数list集合
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param jsonArray    机制参数
     * @return
     */
    List<Map<String, Object>> getMechanismVariableList(String iamUserToken, String tenantId, String locale, JSONArray jsonArray);

    /**
     * 根据taskId、activityId、pageCode获取TM中的活动定义（新做法：请求参数封装成对象，待验证做法）
     *
     * @param athenaApiRequest
     * @return
     */
    KnowledgeMapsActivityDefinition getActivityDefinition(DigiwinAthenaApiRequest athenaApiRequest);

    /**
     * 根据activityId、pageCode获取TM中的活动定义
     *
     * @param athenaApiRequest
     * @return
     */
    KnowledgeMapsActivityDefinition getActivityDefinitionWithoutTaskId(DigiwinAthenaApiRequest athenaApiRequest);

    /**
     * 根据activityId、pageCode获取TM中的活动定义（工作台）
     *
     * @param athenaApiRequest
     * @return
     */
    KnowledgeMapsActivityDefinition getActivityDefinitionOfWorkbench(DigiwinAthenaApiRequest athenaApiRequest);

    /**
     * 获取页面用户界面元素
     *
     * @param athenaApiRequest
     * @return
     */
    PcUiBotTmPageUIElements getPageUIElement(DigiwinAthenaApiRequest athenaApiRequest);

    /**
     * 获取任务TAG配置（新做法：请求参数封装成对象，待验证做法）
     *
     * @param athenaApiRequest
     * @return
     */
    List<KnowledgeMapsTagQueryResult> getTagQueryResult(DigiwinAthenaApiRequest athenaApiRequest);

    /**
     * 获取规则配置（新做法：请求参数封装成对象，待验证做法）
     *
     * @param athenaApiRequest
     * @return
     */
    KnowledgeMapsRuleQueryResult getRuleQueryResult(DigiwinAthenaApiRequest athenaApiRequest);

    /**
     * 是否启用对应参数
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param variable
     * @return
     */
    Boolean getVariable(String iamUserToken, String tenantId, String locale, String variable);

    /**
     * 获取交付设计器参数
     *
     * @param iamUserToken
     * @param tenantId
     * @return
     */
    Map<String, Object> getDeliveryDesignerMap(String iamUserToken, String tenantId);

    /**
     * 获取交付设计器参数
     *
     * @param iamUserToken
     * @param tenantId
     * @param actionId
     * @param paras
     * @return
     */
    Map<String, Object> executionEngine(String iamUserToken, String tenantId, String actionId, List<Map<String, Object>> paras);

    /**
     * 获取知识图谱中保存的行动（Action）元数据
     *
     * @param athenaApiRequest
     * @return
     */
    KnowledgeMapsActionMetadataQueryResult actionMetadata(DigiwinAthenaApiRequest athenaApiRequest);

    /**
     * 获取 用户信息完整性
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @return
     */
    UserIntegrity userIntegrityCheck(String iamUserToken, String tenantId, String locale);

    /**
     * 根据viewCodes查询dataView数据
     *
     * @param athenaApiRequest
     * @return
     */
    KnowledgeMapsDataViewQueryResult queryDataViewList(DigiwinAthenaApiRequest athenaApiRequest);

    /**
     * 根据enumKey获取数据字典，用于获取当前值和对应转化值的映射关系
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param enumKey
     * @return
     */
    List<Map<String, Object>> getDictByKey(String iamUserToken, String tenantId, String locale, String enumKey);

    /**
     * 敏捷数据：数据订阅列表
     *
     * @param request
     * @return
     */
    List<KnowledgeMapsDataSubscriptionModel> queryDataSubscriptionList(DataSubscriptionRequest request);

    /**
     * 敏捷数据：数据订阅新增/更新
     *
     * @param request
     * @return
     */
    Boolean addDataSubscriptionConfig(DataSubscriptionRequest request);

    /**
     * 敏捷数据：数据订阅删除
     *
     * @param request
     * @return
     */
    Boolean removeDataSubscriptionConfig(DataSubscriptionRequest request);

    /**
     * 敏捷数据：数据订阅详情
     *
     * @param iamUserToken
     * @param ruleId
     * @return
     */
    KnowledgeMapsDataSubscriptionModel singleDataSubscriptionConfig(String iamUserToken, String ruleId);

    /**
     * 敏捷数据：查询数据收藏
     *
     * @param queryDTO
     * @return List<DataCollectionModel>
     * @author yanfeng
     */
    List<KnowledgeMapsDataCollectionModel> queryDataCollectConfig(DataCollectConfigQueryDTO queryDTO);

    /**
     * 敏捷数据：新增数据收藏
     *
     * @param request
     * @return String
     * @author yanfeng
     */
    KnowledgeMapsResponse addDataCollectConfig(DataCollectionAddRequest request);

    /**
     * 敏捷数据：删除数据收藏
     *
     * @param request
     * @return Boolean
     * @author yanfeng
     */
    Boolean removeDataCollectConfig(DataCollectionRemoveRequest request);

    /**
     * 敏捷数据：查询示例(娜娜页面:试试这样问我)
     *
     * @param iamUserToken
     * @param locale
     * @return List<SceneIntentionModel>
     * @author yanfeng
     */
    List<KnowledgeMapsSceneIntentionModel> querySceneIntention(String iamUserToken, String locale);

    /**
     * 敏捷数据：查询指令集(娜娜页面:魔法棒)
     *
     * @param iamUserToken
     * @param locale
     * @return List<SceneIntentionModel>
     * @author yanfeng
     */
    List<KnowledgeMapsSceneIntentionModel> querySceneIntentions(String iamUserToken, String locale);

    /**
     * 敏捷数据：新增/更新数据收藏分组
     *
     * @param request
     * @return Boolean
     * @author yanfeng
     */
    Boolean addOrUpdateDataCollectionGroup(DataCollectionGroupAddOrUpdateDTO request);

    /**
     * 敏捷数据：删除数据收藏分组
     *
     * @param request
     * @return Boolean
     * @author yanfeng
     */
    Boolean deleteDataCollectionGroup(DataCollectionGroupDeleteDTO request);

    /**
     * 租户版本
     *
     * @param iamUserToken token
     * @param tenantId 租户id
     * @param locale 语言
     * @return
     */
    String tenantVersion(String iamUserToken, String tenantId, String locale);
}