package com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.*;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderDataUtil;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.*;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.*;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.metadata.KnowledgeMapsActionMetadataQueryResult;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.PcUiBotTmPageUIElements;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.*;

/**
 * @author zhangjj
 * @date 2021/10/28 0028 15:23
 */
@Slf4j
@Service("digiwinKnowledgeMapsProxyServiceImpl")
public class DigiwinKnowledgeMapsProxyServiceImpl implements DigiwinKnowledgeMapsProxyService {
    @Autowired
    private HttpService httpService;

    @Override
    public List<KnowledgeMapsProject> getLaunchableProjects(String iamUserToken, String tenantId, String locale) {
        String url = AppContext.getApiUrlSetting().getKnowledgeMapsUrl() + KG_DOMAIN_API_PREFIX + "/task/manualList";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<Object> responseType =
                new ParameterizedTypeReference<Object>() {
                };

        // 使用object接收 是因为 异常情况下 response返回字符串，debugInfo返回Map，会导致转换异常
        ResponseEntity<Object> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId), new HashMap<>(), responseType);
        if (null == responseEntity || null == responseEntity.getBody()
                || !responseEntity.getStatusCode().is2xxSuccessful()) {
            return Collections.emptyList();
        }
        DigiwinAthenaApiResponse<List<KnowledgeMapsProject>> apiResponse =
                JsonUtil.objectToJavaObject(responseEntity.getBody(), new TypeReference<DigiwinAthenaApiResponse<List<KnowledgeMapsProject>>>() {
                });
        return apiResponse.getResponse();
    }

    @Override
    public List<KnowledgeMapsTbbReport> getTbbReports(String iamUserToken, String locale, String productCode) {
        String url = AppContext.getApiUrlSetting().getAppmetadataUrl() + DATAMAP_DOMAIN_API_PREFIX + "/record/tBBReports?" +
                "mode=mobile&productCode=" + productCode;

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<KnowledgeMapsTbbReport>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<KnowledgeMapsTbbReport>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<List<KnowledgeMapsTbbReport>>> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("", locale, iamUserToken), new HashMap<>(), responseType);
        if (null == responseEntity || null == responseEntity.getBody() || null == responseEntity.getBody().getResponse()
                || !responseEntity.getStatusCode().is2xxSuccessful()) {
            return Collections.emptyList();
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public List<Map<String, Object>> getMechanismVariableList(String iamUserToken, String tenantId,
                                                              String locale, JSONArray jsonArray) {
        String url = AppContext.getApiUrlSetting().getKnowledgeMapsUrl() + KG_DOMAIN_API_PREFIX + "/Mechanism/VariableList";
        Map<String, Object> map = new HashMap<>(1);
        Map<String, Object> uriVariables = new HashMap<>(2);
        uriVariables.put("variableVoList", jsonArray);
        uriVariables.put("needGetDefault", true);
        map.put("map", uriVariables);
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<Map<String, Object>>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<Map<String, Object>>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<List<Map<String, Object>>>> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(map), responseType);
        if (null == responseEntity || null == responseEntity.getBody()
                || null == responseEntity.getBody().getResponse()
                || !responseEntity.getStatusCode().is2xxSuccessful()) {
            return new ArrayList<>();
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public Map<String, Object> getMechanismParamValue(String iamUserToken, String tenantId,
                                                      String locale, String variableName) {
        String url = AppContext.getApiUrlSetting().getKnowledgeMapsUrl() + KG_DOMAIN_API_PREFIX + "/Mechanism/Variable" +
                "?variableName={variableName}&tenantId={tenantId}";
        Map<String, String> uriVariables = new HashMap<>(2);
        uriVariables.put("variableName", variableName);
        uriVariables.put("tenantId", tenantId);

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<Map<String, Object>>> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId), uriVariables, responseType);
        if (null == responseEntity || null == responseEntity.getBody()
                || null == responseEntity.getBody().getResponse()
                || !responseEntity.getStatusCode().is2xxSuccessful()) {
            return new HashMap<>();
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public List<Map<String, Object>> getMechanismCapabilityCode(String iamUserToken, String tenantId,
                                                                String locale, List<String> stringList) {
        String url = AppContext.getApiUrlSetting().getKnowledgeMapsUrl() + KG_DOMAIN_API_PREFIX + "/mechanism/mechanismApplyRecord";


        Map<String, Object> query = new HashMap<>(1);

        query.put("mechanismAbilityCode", stringList);
        Map<String, Object> inputMap = new HashMap(1);
        inputMap.put("query", query);
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<Map<String, Object>>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<Map<String, Object>>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<List<Map<String, Object>>>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(inputMap), responseType);
        if (null == responseEntity || null == responseEntity.getBody()
                || null == responseEntity.getBody().getResponse()
                || !responseEntity.getStatusCode().is2xxSuccessful()) {
            return new ArrayList<>();
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public Map<String, Object> getVariableListSimple(String iamUserToken, String tenantId,
                                                     String locale, List<String> codeList) {
        String url = AppContext.getApiUrlSetting().getKnowledgeMapsUrl() + KG_DOMAIN_API_PREFIX + "/mechanism/VariableListSimple";


        Map<String, Object> query = new HashMap<>(1);
        query.put("variableIds", codeList);
        Map<String, Object> inputMap = new HashMap(1);
        inputMap.put("map", query);
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<Map<String, Object>>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(inputMap), responseType);
        if (null == responseEntity || null == responseEntity.getBody()
                || null == responseEntity.getBody().getResponse()
                || !responseEntity.getStatusCode().is2xxSuccessful()) {
            return new HashMap<>();
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public KnowledgeMapsActivityDefinition getActivityDefinition(DigiwinAthenaApiRequest athenaApiRequest) {
        String url = AppContext.getApiUrlSetting().getAppmetadataUrl() + DATAMAP_DOMAIN_API_PREFIX + "/record/activityDefinition"
                + "?taskId={taskId}&activityId={activityId}&pageCode={pageCode}";
        return this.getActivityDefinition(athenaApiRequest, url);
    }

    @Override
    public KnowledgeMapsActivityDefinition getActivityDefinitionWithoutTaskId(DigiwinAthenaApiRequest athenaApiRequest) {
        String url = AppContext.getApiUrlSetting().getAppmetadataUrl() + DATAMAP_DOMAIN_API_PREFIX + "/record/activityDefinition"
                + "?activityId={activityId}&pageCode={pageCode}";
        return this.getActivityDefinition(athenaApiRequest, url);
    }

    @Override
    public KnowledgeMapsActivityDefinition getActivityDefinitionOfWorkbench(DigiwinAthenaApiRequest athenaApiRequest) {
        String url = AppContext.getApiUrlSetting().getKnowledgeMapsUrl() + KG_DOMAIN_API_PREFIX + "/workbench/activityDefinition"
                + "?activityId={activityId}&pageCode={pageCode}";
        return this.getActivityDefinition(athenaApiRequest, url);
    }

    private KnowledgeMapsActivityDefinition getActivityDefinition(DigiwinAthenaApiRequest athenaApiRequest, String url) {
        if (StringUtils.hasLength(AppRequestContext.getContextEntity().getProxyToken())) {
            athenaApiRequest.getRequestHead().setUserToken(AppRequestContext.getContextEntity().getProxyToken());
        }
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<KnowledgeMapsActivityDefinition>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<KnowledgeMapsActivityDefinition>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<KnowledgeMapsActivityDefinition>> responseEntity =
                this.httpService.doGet(url, athenaApiRequest.getRequestHead(), athenaApiRequest.getUriVariables(), responseType);
        if (null == responseEntity || null == responseEntity.getBody()) {
            log.error("Error occurred when get task activityDefinition from Athena KM...Error");
            return new KnowledgeMapsActivityDefinition();
        } else if (null == responseEntity.getBody().getResponse() || !responseEntity.getStatusCode().is2xxSuccessful()) {
            log.error("Error occurred when get task activityDefinition from Athena KM...Error message is: {}",
                    responseEntity.getBody().getErrorMessage());
            return new KnowledgeMapsActivityDefinition();
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public PcUiBotTmPageUIElements getPageUIElement(DigiwinAthenaApiRequest athenaApiRequest) {
        String url = AppContext.getApiUrlSetting().getAppmetadataUrl() + DATAMAP_DOMAIN_API_PREFIX + "/view/pageUIElement";
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<PcUiBotTmPageUIElements>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<PcUiBotTmPageUIElements>>>() {
                };
        try {
            ResponseEntity<DigiwinAthenaApiResponse<List<PcUiBotTmPageUIElements>>> responseEntity =
                    this.httpService.doPost(url, athenaApiRequest.getRequestHead(),
                            JsonUtil.javaObjectToJsonString(athenaApiRequest.getBodyPayloadMap()), responseType);
            if (null == responseEntity || null == responseEntity.getBody()) {
                log.error("Error occurred when get task pageUIElement from Athena KM...Error");
                return new PcUiBotTmPageUIElements();
            } else if (null == responseEntity.getBody().getResponse() || !responseEntity.getStatusCode().is2xxSuccessful()) {
                log.error("Error occurred when get task pageUIElement from Athena KM...Error message is: {}",
                        responseEntity.getBody().getErrorMessage());
                return null;
            }
            return CollectionUtils.isEmpty(responseEntity.getBody().getResponse()) ?
                    new PcUiBotTmPageUIElements() : responseEntity.getBody().getResponse().get(0);
        } catch (Exception e) {
            log.error("Error occurred when get task pageUIElement from Athena KM...Error");
            return new PcUiBotTmPageUIElements();
        }
    }

    @Override
    public List<KnowledgeMapsTagQueryResult> getTagQueryResult(DigiwinAthenaApiRequest athenaApiRequest) {
        String url = AppContext.getApiUrlSetting().getThemeMapUrl() + TAG_DOMAIN_API_PREFIX + "/tag/query";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<KnowledgeMapsTagQueryResult>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<KnowledgeMapsTagQueryResult>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<List<KnowledgeMapsTagQueryResult>>> responseEntity =
                this.httpService.doPost(url, athenaApiRequest.getRequestHead(),
                        JsonUtil.javaObjectToJsonString(athenaApiRequest.getBodyPayloadMap()), responseType);
        if (null == responseEntity || null == responseEntity.getBody()) {
            log.error("Error occurred when get TAG from Athena KM...Error");
            return Collections.emptyList();
        } else if (null == responseEntity.getBody().getResponse() || !responseEntity.getStatusCode().is2xxSuccessful()) {
            log.error("Error occurred when get TAG from Athena KM...Error message is: {}",
                    responseEntity.getBody().getErrorMessage());
            return Collections.emptyList();
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public KnowledgeMapsRuleQueryResult getRuleQueryResult(DigiwinAthenaApiRequest athenaApiRequest) {
        if (StringUtils.hasLength(AppRequestContext.getContextEntity().getProxyToken())) {
            athenaApiRequest.getRequestHead().setUserToken(AppRequestContext.getContextEntity().getProxyToken());
        }
        String url = AppContext.getApiUrlSetting().getAppmetadataUrl() + DATAMAP_API_PREFIX + "/rule/query";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<KnowledgeMapsRuleQueryResult>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<KnowledgeMapsRuleQueryResult>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<KnowledgeMapsRuleQueryResult>> responseEntity =
                this.httpService.doPost(url, athenaApiRequest.getRequestHead(),
                        JsonUtil.javaObjectToJsonString(athenaApiRequest.getBodyPayloadMap()), responseType);
        if (null == responseEntity || null == responseEntity.getBody()) {
            log.error("Error occurred when get Rule from Athena KM...Error");
            return new KnowledgeMapsRuleQueryResult();
        } else if (null == responseEntity.getBody().getResponse() || !responseEntity.getStatusCode().is2xxSuccessful()) {
            log.error("Error occurred when get Rule from Athena KM...Error message is: {}",
                    responseEntity.getBody().getErrorMessage());
            return new KnowledgeMapsRuleQueryResult();
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public Boolean getVariable(String iamUserToken, String tenantId, String locale, String variable) {
        String url = AppContext.getApiUrlSetting().getKnowledgeMapsUrl() + KG_DOMAIN_API_PREFIX +
                "/Mechanism/Variable?variableName=" + variable + "&tenantId=" + tenantId;

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<Map>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId), responseType);
        if (null == responseEntity || null == responseEntity.getBody()
                || null == responseEntity.getBody().getResponse()
                || !responseEntity.getStatusCode().is2xxSuccessful()) {
            // TODO 异常处理
            throw new ServiceException("");
        }
        return (Boolean) responseEntity.getBody().getResponse().get(variable);
    }

    /**
     * @param iamUserToken
     * @param tenantId
     * @return 出参字段说明：
     * Integration_parameters 集成参数
     * device_name_hidden 设备是否隐藏 Y：隐藏 N：不隐藏
     * project_info_required 项目应用集成时项目信息是否必填 1:必填 2：非必填
     * project_personnel_authority 项目人员权限是否开启 Y:开启 N:不开启
     * field_handling_instructions_required 现场处理说明是否必填 Y:必填 N：非必填
     * supplier_controls_external_maintenance 供应商是否控制仅外部可维护 Y:开启 N:不开启
     * supplier_source 供应商来源 : ERP,鼎捷云
     */
    @Override
    public Map<String, Object> getDeliveryDesignerMap(String iamUserToken, String tenantId) {
        String url = AppContext.getApiUrlSetting().getSmartDataUrl() + SMARTDATA_PREFIX +
                "/ExecutionEngine/execute";
        Map<String, Object> bodyPayLoad = new HashMap<>(4);
        bodyPayLoad.put("tenantId", tenantId);
        bodyPayLoad.put("actionId", "QuestionAnswer_DataPulling");
        bodyPayLoad.put("eocMap", "{}");
        bodyPayLoad.put("paras", new ArrayList<>(1));
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<Map>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(bodyPayLoad), responseType);
        if (null == responseEntity || null == responseEntity.getBody()
                || null == responseEntity.getBody().getResponse()
                || !responseEntity.getStatusCode().is2xxSuccessful()) {
            // TODO 异常处理
            throw new ServiceException("");
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public Map<String, Object> executionEngine(String iamUserToken, String tenantId, String actionId, List<Map<String, Object>> paras) {
        String url = AppContext.getApiUrlSetting().getSmartDataUrl() + SMARTDATA_PREFIX +
                "/ExecutionEngine/execute";
        Map<String, Object> bodyPayLoad = new HashMap<>(4);
        bodyPayLoad.put("tenantId", tenantId);
        bodyPayLoad.put("actionId", actionId);
        bodyPayLoad.put("eocMap", "{}");
        bodyPayLoad.put("paras", paras);
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<Map>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(bodyPayLoad), responseType);
        if (null == responseEntity || null == responseEntity.getBody()
                || null == responseEntity.getBody().getResponse()
                || !responseEntity.getStatusCode().is2xxSuccessful()) {
            // TODO 异常处理
            throw new ServiceException("");
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public UserIntegrity userIntegrityCheck(String iamUserToken, String tenantId, String locale) {
        String url = AppContext.getApiUrlSetting().getKnowledgeMapsUrl() + KG_DOMAIN_API_PREFIX
                + "/tenant/userIntegrityCheck";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<Object> responseType =
                new ParameterizedTypeReference<Object>() {
                };

        // 使用object接收 是因为 异常情况下 response返回字符串，debugInfo返回Map，会导致转换异常
        ResponseEntity<Object> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId), new HashMap<>(), responseType);

        if (null == responseEntity || null == responseEntity.getBody()
                || !responseEntity.getStatusCode().is2xxSuccessful()) {
            return new UserIntegrity().setUserIntegrity(true);
        }
        DigiwinAthenaApiResponse<UserIntegrity> response = JsonUtil.objectToJavaObject(responseEntity.getBody(), new TypeReference<DigiwinAthenaApiResponse<UserIntegrity>>() {
        });
        if (null == response || null == response.getResponse()) {
            return new UserIntegrity().setUserIntegrity(true);
        }
        return response.getResponse();
    }

    @Override
    public KnowledgeMapsActionMetadataQueryResult actionMetadata(DigiwinAthenaApiRequest athenaApiRequest) {
        String str = AppContext.getApiUrlSetting().getKnowledgeMapsUrl() + KG_DOMAIN_API_PREFIX
                + "/Action/Metadata?";
        StringBuilder urlSbuilder = new StringBuilder(str);

        Map<String, String> uriVariables = athenaApiRequest.getUriVariables();
        if (!CollectionUtils.isEmpty(uriVariables)) {
            for (String uriVarKey : uriVariables.keySet()) {
                urlSbuilder.append(uriVarKey).append("=").append(uriVariables.get(uriVarKey)).append("&");
            }
        }
        String url = urlSbuilder.substring(0, urlSbuilder.length() - 1).toString();
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<KnowledgeMapsActionMetadataQueryResult>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<KnowledgeMapsActionMetadataQueryResult>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<KnowledgeMapsActionMetadataQueryResult>> responseEntity =
                this.httpService.doGet(url, athenaApiRequest.getRequestHead(), responseType);
        if (null == responseEntity || null == responseEntity.getBody()) {
            log.error("Error occurred when get ActionMetadata from Athena KM...Error");
            return new KnowledgeMapsActionMetadataQueryResult();
        } else if (null == responseEntity.getBody().getResponse() || !responseEntity.getStatusCode().is2xxSuccessful()) {
            log.error("Error occurred when get ActionMetadata from Athena KM...Error message is: {}",
                    responseEntity.getBody().getErrorMessage());
            return new KnowledgeMapsActionMetadataQueryResult();
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public KnowledgeMapsDataViewQueryResult queryDataViewList(DigiwinAthenaApiRequest athenaApiRequest) {
        String url = AppContext.getApiUrlSetting().getKnowledgeMapsUrl() + KG_DOMAIN_API_PREFIX + "/task/dataViewList";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<Map<String, Object>>> responseEntity =
                this.httpService.doPost(url, athenaApiRequest.getRequestHead(),
                        JsonUtil.javaObjectToJsonString(athenaApiRequest.getBodyPayloadMap()), responseType);

        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            throw new ServiceException(Optional.ofNullable(responseEntity.getBody())
                    .map(DigiwinAthenaApiResponse::getErrorMessage)
                    .orElse("Api " + url + " call error!"));
        }
        if (null == responseEntity.getBody()) {
            return null;
        }
        Map<String, Object> map = responseEntity.getBody().getResponse();
        if (map == null) {
            return null;
        }
        // 多语言处理
        MobileRenderDataUtil.multilingualProcessing(map, AppRequestContext.getContextEntity().getLocale());
        return JsonUtil.objectToJavaObject(map, KnowledgeMapsDataViewQueryResult.class);
    }

    @Override
    public List<Map<String, Object>> getDictByKey(String iamUserToken, String tenantId, String locale, String enumKey) {
        String url = AppContext.getApiUrlSetting().getAppmetadataUrl() + DATAMAP_DOMAIN_API_PREFIX +
                "/dict/DictByKey?key=" + enumKey;

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<Map<String, Object>>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<Map<String, Object>>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<List<Map<String, Object>>>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId), responseType);
        if (null == responseEntity || null == responseEntity.getBody()
                || null == responseEntity.getBody().getResponse()
                || !responseEntity.getStatusCode().is2xxSuccessful()) {
            // TODO 异常处理
            throw new ServiceException("");
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public List<KnowledgeMapsDataSubscriptionModel> queryDataSubscriptionList(DataSubscriptionRequest request) {
        String url = AppContext.getApiUrlSetting().getAgileDataQueryUrl() + ADQ_API_SUFFIX +
                "/dataSubscription/queryDataSubscriptionConfig";
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<KnowledgeMapsDataSubscriptionModel>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<KnowledgeMapsDataSubscriptionModel>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<List<KnowledgeMapsDataSubscriptionModel>>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(request.getIamUserToken()), JsonUtil.javaObjectToJsonString(handleDataSubscription(request)), responseType);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            if (null == responseEntity.getBody() || CollectionUtils.isEmpty(responseEntity.getBody().getResponse())) {
                return new ArrayList<>();
            } else {
                return responseEntity.getBody().getResponse();
            }
        } else {
            log.error("数据订阅,queryDataSubscriptionList异常:{}", JsonUtil.javaObjectToJsonString(responseEntity));
        }
        return new ArrayList<>();
    }

    @Override
    public Boolean addDataSubscriptionConfig(DataSubscriptionRequest request) {
        String url = AppContext.getApiUrlSetting().getAgileDataQueryUrl() + ADQ_API_SUFFIX +
                "/dataSubscription/addDataSubscriptionConfig";
        Map<String, Object> bodyPayLoad = new HashMap<>(1);
        bodyPayLoad.put("config", request.getDataSubscriptionModel());

        ResponseEntity<JSONObject> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(request.getIamUserToken()),
                JsonUtil.javaObjectToJsonString(bodyPayLoad), JSONObject.class);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            if (null != responseEntity.getBody()) {
                Object response = responseEntity.getBody().get("response");
                return response.equals("success");
            }
        } else {
            log.error("数据订阅,addDataSubscriptionConfig异常:{}", JsonUtil.javaObjectToJsonString(responseEntity));
        }
        return false;
    }

    @Override
    public Boolean removeDataSubscriptionConfig(DataSubscriptionRequest request) {
        String url = AppContext.getApiUrlSetting().getAgileDataQueryUrl() + ADQ_API_SUFFIX +
                "/dataSubscription/removeDataSubscriptionConfig";
        ResponseEntity<JSONObject> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(request.getIamUserToken()), JsonUtil.javaObjectToJsonString(handleDataSubscription(request)), JSONObject.class);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            if (null != responseEntity.getBody()) {
                Object response = responseEntity.getBody().get("response");
                return response.equals("success");
            }
        } else {
            log.error("数据订阅,removeDataSubscriptionConfig异常:{}", JsonUtil.javaObjectToJsonString(responseEntity));
        }
        return false;
    }

    private Map<String, Object> handleDataSubscription(DataSubscriptionRequest request) {
        Map<String, Object> bodyPayLoad = new HashMap<>(4);
        bodyPayLoad.put("tenantId", request.getTenantId());

        //删除订阅：如果有ruleId,只传tenantId和ruleIds
        if (!ObjectUtils.isEmpty(request.getDataSubscriptionModel())
                && !ObjectUtils.isEmpty(request.getDataSubscriptionModel().getRuleId())) {
            bodyPayLoad.put("ruleIds", Collections.singletonList(request.getDataSubscriptionModel().getRuleId()));
            return bodyPayLoad;
        }

        bodyPayLoad.put("userId", request.getUserId());
        if (org.apache.commons.lang3.StringUtils.isNotBlank(request.getQuestion())) {
            bodyPayLoad.put("question", request.getQuestion());
        } else {
            //dap框架,空值也要传此字段 空字符串，否则报400错误~
            bodyPayLoad.put("question", "");
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(request.getSceneCode())) {
            bodyPayLoad.put("sceneCode", request.getSceneCode());
        } else {
            //dap框架,空值也要传此字段 空字符串，否则报400错误~
            bodyPayLoad.put("sceneCode", "");
        }
        if (!CollectionUtils.isEmpty(request.getMetricIdList())) {
            bodyPayLoad.put("metricIdList", request.getMetricIdList());
        } else {
            //dap框架,空值也要传此字段 空字符串，否则报400错误~
            bodyPayLoad.put("metricIdList", new ArrayList<>());
        }
        if (!CollectionUtils.isEmpty(request.getDatasetIdList())) {
            bodyPayLoad.put("datasetIdList", request.getDatasetIdList());
        } else {
            //dap框架,空值也要传此字段 空字符串，否则报400错误~
            bodyPayLoad.put("datasetIdList", new ArrayList<>());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(request.getAsaCode())) {
            bodyPayLoad.put("asaCode", request.getAsaCode());
        } else {
            //dap框架,空值也要传此字段 空字符串，否则报400错误~
            bodyPayLoad.put("asaCode", "");
        }
        return bodyPayLoad;
    }

    @Override
    public KnowledgeMapsDataSubscriptionModel singleDataSubscriptionConfig(String iamUserToken, String ruleId) {
        String url = AppContext.getApiUrlSetting().getAgileDataQueryUrl() + ADQ_API_SUFFIX +
                "/dataSubscription/singleDataSubscriptionConfig?ruleId=" + ruleId;
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<KnowledgeMapsDataSubscriptionModel>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<KnowledgeMapsDataSubscriptionModel>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<KnowledgeMapsDataSubscriptionModel>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead(iamUserToken), responseType);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            if (null == responseEntity.getBody() || null == responseEntity.getBody().getResponse()) {
                return null;
            } else {
                return responseEntity.getBody().getResponse();
            }
        } else {
            log.error("数据订阅,singleDataSubscriptionConfig异常:{}", JsonUtil.javaObjectToJsonString(responseEntity));
        }
        return null;
    }

    @Override
    public List<KnowledgeMapsDataCollectionModel> queryDataCollectConfig(DataCollectConfigQueryDTO queryDTO) {
        String url = AppContext.getApiUrlSetting().getAgileDataQueryUrl() + ADQ_API_SUFFIX +
                "/dataCollect/queryDataCollectConfig";
        // 构建请求参数
        Map<String, Object> params = new HashMap<>(1);
        Map<String, Object> map = new HashMap<>(4);
        map.put("asaCode", queryDTO.getAsaCode());
        map.put("groupId", queryDTO.getGroupId());
        params.put("queryConfig", map);

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<KnowledgeMapsDataCollectionModel>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<KnowledgeMapsDataCollectionModel>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<List<KnowledgeMapsDataCollectionModel>>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", queryDTO.getLocale(), queryDTO.getIamUserToken(), queryDTO.getTenantId()),
                        JsonUtil.javaObjectToJsonString(params), responseType);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            if (null == responseEntity.getBody() || null == responseEntity.getBody().getResponse()) {
                return Collections.emptyList();
            } else {
                return responseEntity.getBody().getResponse();
            }
        } else {
            log.error("数据收藏,queryDataCollectConfig异常:{}", JsonUtil.javaObjectToJsonString(responseEntity));
        }
        return Collections.emptyList();
    }

    @Override
    public KnowledgeMapsResponse addDataCollectConfig(DataCollectionAddRequest request) {
        String url = AppContext.getApiUrlSetting().getAgileDataQueryUrl() + ADQ_API_SUFFIX +
                "/dataCollect/addDataCollectConfig";
        Map<String, Object> bodyPayLoad = new HashMap<>(1);
        bodyPayLoad.put("config", request);

        ResponseEntity<KnowledgeMapsResponse> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", request.getLocale(), request.getIamUserToken(), request.getTenantId()),
                JsonUtil.javaObjectToJsonString(bodyPayLoad), KnowledgeMapsResponse.class);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            log.error("数据收藏,addDataCollectConfig异常:{}", JsonUtil.javaObjectToJsonString(responseEntity));
        }
        return responseEntity.getBody();
    }

    @Override
    public Boolean removeDataCollectConfig(DataCollectionRemoveRequest request) {
        String url = AppContext.getApiUrlSetting().getAgileDataQueryUrl() + ADQ_API_SUFFIX +
                "/dataCollect/removeDataCollectConfig";
        Map<String, Object> bodyPayLoad = new HashMap<>(1);
        bodyPayLoad.put("config", request);
        ResponseEntity<JSONObject> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(request.getIamUserToken()), JsonUtil.javaObjectToJsonString(bodyPayLoad), JSONObject.class);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            if (null != responseEntity.getBody()) {
                Object response = responseEntity.getBody().get("response");
                return response.equals("success");
            }
        } else {
            log.error("数据收藏,removeDataCollectConfig异常:{}", JsonUtil.javaObjectToJsonString(responseEntity));
        }
        return false;
    }

    @Override
    public List<KnowledgeMapsSceneIntentionModel> querySceneIntention(String iamUserToken, String locale) {
        String url = AppContext.getApiUrlSetting().getKnowledgeMapsUrl() + KG_DOMAIN_API_PREFIX +
                "/scene/querySceneIntention";
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<KnowledgeMapsSceneIntentionModel>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<KnowledgeMapsSceneIntentionModel>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<List<KnowledgeMapsSceneIntentionModel>>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, iamUserToken), responseType);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            if (null == responseEntity.getBody() || CollectionUtils.isEmpty(responseEntity.getBody().getResponse())) {
                return new ArrayList<>();
            } else {
                return responseEntity.getBody().getResponse();
            }
        } else {
            log.error("娜娜页面示例,querySceneIntention异常:{}", JsonUtil.javaObjectToJsonString(responseEntity));
        }
        return new ArrayList<>();
    }

    @Override
    public List<KnowledgeMapsSceneIntentionModel> querySceneIntentions(String iamUserToken, String locale) {
        String url = AppContext.getApiUrlSetting().getKnowledgeMapsUrl() + KG_DOMAIN_API_PREFIX +
                "/scene/querySceneIntentions";
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<KnowledgeMapsSceneIntentionModel>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<KnowledgeMapsSceneIntentionModel>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<List<KnowledgeMapsSceneIntentionModel>>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, iamUserToken), responseType);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            if (null == responseEntity.getBody() || CollectionUtils.isEmpty(responseEntity.getBody().getResponse())) {
                return new ArrayList<>();
            } else {
                return responseEntity.getBody().getResponse();
            }
        } else {
            log.error("娜娜页面魔法棒指令集,querySceneIntentions异常:{}", JsonUtil.javaObjectToJsonString(responseEntity));
        }
        return new ArrayList<>();
    }

    @Override
    public Boolean addOrUpdateDataCollectionGroup(DataCollectionGroupAddOrUpdateDTO request) {
        String url = AppContext.getApiUrlSetting().getAgileDataQueryUrl() + ADQ_API_SUFFIX +
                "/dataCollectGroup/addDataCollectGroupConfig";

        // 构建请求参数
        Map<String, Object> params = new HashMap<>(1);
        params.put("config", request.getConfig());

        try {
            ResponseEntity<JSONObject> responseEntity = this.httpService.doPost(
                    url,
                    new AthenaBasicHttpRequestHead("", request.getLocale(), request.getIamUserToken(), request.getTenantId()),
                    JsonUtil.javaObjectToJsonString(params),
                    JSONObject.class
            );
            // 检查响应状态
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                JSONObject body = responseEntity.getBody();
                return body != null && "success".equals(body.get("response"));
            } else {
                log.error("数据收藏分组,addOrUpdateDataCollectionGroup异常,入参:{}, 响应:{}",
                        JsonUtil.javaObjectToJsonString(request),
                        JsonUtil.javaObjectToJsonString(responseEntity));
            }
        } catch (Exception e) {
            log.error("数据收藏分组,addOrUpdateDataCollectionGroup发生异常: {}", e.getMessage(), e);
        }
        return false;
    }

    @Override
    public Boolean deleteDataCollectionGroup(DataCollectionGroupDeleteDTO request) {
        String url = AppContext.getApiUrlSetting().getAgileDataQueryUrl() + ADQ_API_SUFFIX +
                "/dataCollectGroup/removeDataCollectGroupConfig";
        // 构建请求参数
        Map<String, Object> params = new HashMap<>(1);
        Map<String, Object> map = new HashMap<>(2);
        map.put("groupIds", request.getGroupIds());
        map.put("asaCode", request.getAsaCode());
        params.put("delConfig", map);
        try {
            ResponseEntity<JSONObject> responseEntity = this.httpService.doPost(
                    url,
                    new AthenaBasicHttpRequestHead("", request.getLocale(), request.getIamUserToken(), request.getTenantId()),
                    JsonUtil.javaObjectToJsonString(params),
                    JSONObject.class
            );
            // 检查响应状态
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                JSONObject body = responseEntity.getBody();
                return body != null && "success".equals(body.get("response"));
            } else {
                log.error("数据收藏分组,deleteDataCollectionGroup异常,入参:{}, 响应:{}",
                        JsonUtil.javaObjectToJsonString(request),
                        JsonUtil.javaObjectToJsonString(responseEntity));
            }
        } catch (Exception e) {
            log.error("数据收藏分组,deleteDataCollectionGroup发生异常: {}", e.getMessage(), e);
        }
        return false;
    }

    @Override
    public String tenantVersion(String iamUserToken, String tenantId, String locale) {
        if (AppContext.getApiUrlSetting().getAgileDataPrivatization()) {
            return "2.0";
        }

        String url = AppContext.getApiUrlSetting().getAppmetadataUrl() + DATAMAP_DOMAIN_API_PREFIX +
                "/tenant/tenantVersion?tenantId=" + tenantId;

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<String>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<String>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<String>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId), responseType);
        if (null == responseEntity || null == responseEntity.getBody()
                || null == responseEntity.getBody().getResponse()
                || !responseEntity.getStatusCode().is2xxSuccessful()) {
            return null;
        }
        return responseEntity.getBody().getResponse();
    }
}