package com.digiwin.mobile.mobileuibot.proxy.mdc.service;

import com.digiwin.mobile.mobileuibot.proxy.mdc.model.EocSetInfo;

import java.util.Map;

/**
 * <p>功能描述：鼎捷雅典娜 mdc 服务调用类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinMdcProxyService
 * @Author: Zaregoto
 * @Date: 2021/6/28 21:31
 */
public interface DigiwinMdcProxyService {

    String API_PREFIX = "/restful/standard/mdc";

    /**
     * 获取 用户 eoc 配置
     *
     * @param iamUserToken
     * @param tenantId
     * @param userId
     * @return
     */
    EocSetInfo eocSetInfo(String iamUserToken, String tenantId, String userId);

    /**
     * 获取 产品线信息
     *
     * @param iamUserToken
     * @param tenantId
     * @return
     */
    Map<String, Object> getTenantProductType(String iamUserToken, String tenantId);

    /**
     * 判断产品线是否为E10或T100
     *
     * @param iamUserToken
     * @param tenantId
     * @return
     */
    boolean isProductGatewayE10orT100(String iamUserToken, String tenantId);
}
