package com.digiwin.mobile.mobileuibot.proxy.mdc.service.impl;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.mdc.model.EocSetInfo;
import com.digiwin.mobile.mobileuibot.proxy.mdc.service.DigiwinMdcProxyService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinMdcProxyServiceImpl
 * @Author: Zaregoto
 * @Date: 2021/6/29 21:06
 */
@Service
public class DigiwinMdcProxyServiceImpl implements DigiwinMdcProxyService {

    @Autowired
    private HttpService httpService;

    @Override
    public EocSetInfo eocSetInfo(String iamUserToken, String tenantId, String userId) {
        String url = AppContext.getApiUrlSetting().getMdcUrl() + DigiwinMdcProxyService.API_PREFIX
                + "/tenant/EocSetInfo";

        Map<String, String> bodyPayLoad = new HashMap<>(2);
        bodyPayLoad.put("tenant_id", tenantId);
        bodyPayLoad.put("user_id", userId);

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<EocSetInfo>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<EocSetInfo>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<EocSetInfo>> responseEntity =
                httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken),
                        JsonUtil.javaObjectToJsonString(bodyPayLoad), responseType);

        if (null == responseEntity
                || !responseEntity.getStatusCode().is2xxSuccessful()
                || null == responseEntity.getBody()
                || null == responseEntity.getBody().getResponse()) {
            return new EocSetInfo().setRemindUnitSetting(false);
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public Map<String, Object> getTenantProductType(String iamUserToken, String tenantId) {
        String url = AppContext.getApiUrlSetting().getMdcUrl() + DigiwinMdcProxyService.API_PREFIX
                + "/TenantProductType/Get";

        Map<String, String> bodyPayLoad = new HashMap<>(2);
        bodyPayLoad.put("tenant_id", tenantId);
        bodyPayLoad.put("prod_type", "ERP");

        ResponseEntity<Map> responseEntity =
                httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken),
                        JsonUtil.javaObjectToJsonString(bodyPayLoad), Map.class);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() && ObjectUtils.isNotEmpty(responseEntity.getBody()) ?
                responseEntity.getBody() : Collections.emptyMap();
    }

    @Override
    public boolean isProductGatewayE10orT100(String iamUserToken, String tenantId) {
        Map<String, Object> tenantProductTypeInfoMap = getTenantProductType(iamUserToken, tenantId);
        Map<String, Object> data = (Map<String, Object>) MapUtil.getOrDefault(tenantProductTypeInfoMap, "data", Collections.emptyMap());
        List<Map<String, Object>> gatewayList = (List<Map<String, Object>>) MapUtil.getOrDefault(data, "gateway", Collections.emptyList());
        if (CollectionUtils.isEmpty(gatewayList)) {
            return false;
        }
        List<Map<String, Object>> productList = (List<Map<String, Object>>) MapUtil.getOrDefault(gatewayList.get(0), "product", Collections.emptyMap());
        if (CollectionUtils.isEmpty(productList)) {
            return false;
        }
        String name = (String) MapUtil.getOrDefault(productList.get(0), "name", StringUtils.EMPTY);
        return name.indexOf("E10") > -1 || name.indexOf("T100") > -1;
    }
}
