package com.digiwin.mobile.mobileuibot.proxy.model;

import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPerson;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamAuthoredUser;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamTokenRefreshTenant;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>功能描述：切换租户并刷新token 接口的响应数据模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ProxyRefreshTenant
 * @Author: Zaregoto
 * @Date: 2021/4/21 13:56
 */
@Data
public class ProxyRefreshTenant implements Serializable {
    private static final long serialVersionUID = -3827979299626027453L;

    private Long tenantSid;
    private String tenantId;
    private String tenantName;
    private String userToken;
    private DigiwinIamAuthoredUser authoredUser;
    /**
     * EOC 人员详细信息
     */
    private EocPerson eoc;

    public static ProxyRefreshTenant create(DigiwinIamTokenRefreshTenant iamTokenRefreshTenant) {
        return new ProxyRefreshTenant(iamTokenRefreshTenant.getTenantSid(),
                iamTokenRefreshTenant.getTenantId(), iamTokenRefreshTenant.getTenantName(),
                iamTokenRefreshTenant.getUserToken(), iamTokenRefreshTenant.getAuthoredUser());
    }

    private ProxyRefreshTenant() {
    }

    private ProxyRefreshTenant(Long tenantSid, String tenantId, String tenantName,
                               String userToken, DigiwinIamAuthoredUser authoredUser) {
        this.tenantSid = tenantSid;
        this.tenantId = tenantId;
        this.tenantName = tenantName;
        this.userToken = userToken;
        this.authoredUser = authoredUser;
    }
}
