package com.digiwin.mobile.mobileuibot.proxy.model;

import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamTenant;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>功能描述：获取租户列表 接口的响应数据模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ProxyTenant
 * @Author: Zaregoto
 * @Date: 2021/4/21 14:02
 */
public class ProxyTenant implements Serializable {
    private static final long serialVersionUID = -9177383889627478913L;

    private Long tenantSid;
    private String tenantId;
    private String tenantName;
    // 租户版本，v2(新组织架构)，其它(旧组织架构)
    private String version;

    public static ProxyTenant create(DigiwinIamTenant digiwinIamTenant) {
        return new ProxyTenant(digiwinIamTenant.getSid(), digiwinIamTenant.getId(),
                digiwinIamTenant.getName(), digiwinIamTenant.getVersion());
    }

    public static List<ProxyTenant> create(List<DigiwinIamTenant> digiwinIamTenants) {
        List<ProxyTenant> proxyTenants = new ArrayList<>(digiwinIamTenants.size());
        digiwinIamTenants.stream().forEach(element -> {
            proxyTenants.add(ProxyTenant.create(element));
        });
        return proxyTenants;
    }

    private ProxyTenant() {
    }

    private ProxyTenant(Long tenantSid, String tenantId, String tenantName, String version) {
        this.tenantSid = tenantSid;
        this.tenantId = tenantId;
        this.tenantName = tenantName;
        this.version = version;
    }

    public Long getTenantSid() {
        return tenantSid;
    }

    public void setTenantSid(Long tenantSid) {
        this.tenantSid = tenantSid;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantName() {
        return tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}
