package com.digiwin.mobile.mobileuibot.proxy.mrs.service.impl;

import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.mrs.model.AuxiliaryInformationResponse;
import com.digiwin.mobile.mobileuibot.proxy.mrs.service.MrsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @author wuyang
 */
@Service("mrsService")
public class MrsServiceImpl implements MrsService {


    @Autowired
    private HttpService httpService;

    @Autowired
    private SysEnvConfig sysEnvConfig;

    @Override
    public AuxiliaryInformationResponse recommendedAuxiliaryInformation(Map<String, Object> params) {
        String url = sysEnvConfig.getAiUrl() + MrsService.API_PREFIX
                + "/recommended-auxiliary-information";
        String userToken = (String) params.get("userToken");
        String locale = (String) params.get("locale");
        ParameterizedTypeReference<DigiwinAthenaApiResponse<AuxiliaryInformationResponse>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<AuxiliaryInformationResponse>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<AuxiliaryInformationResponse>> responseEntity =
                httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, userToken), JsonUtil.javaObjectToJsonString(params), responseType);
        if (responseEntity != null && responseEntity.getStatusCode().is2xxSuccessful()) {
            return responseEntity.getBody().getResponse();
        }
        return null;
    }
}
