package com.digiwin.mobile.mobileuibot.proxy.ocr.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * ocr识别动态参数
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class OcrData implements Serializable{
    private static final long serialVersionUID = 7282861754345145196L;

    /**
     * 第三方字段key
     */
    private String field;
    /**
     * 前端显示标题
     */
    private String fieldTitle;
    /**
     * 第三方字段value
     */
    private String fieldValue;
    /**
     * 移动的字段key
     */
    private String mobileField;
    /**
     * 是否可编辑
     */
    private Boolean editable;
    /**
     * 是否显示
     */
    private Boolean display;
    /**
     * 是否必填
     */
    private Boolean required;
    /**
     * 次序，从0开始
     */
    private Integer order;
}
