package com.digiwin.mobile.mobileuibot.proxy.ocr.service;

import com.digiwin.mobile.mobileuibot.ocr.model.ApiRequestOcr;
import com.digiwin.mobile.mobileuibot.ocr.model.OcrCarNumberResult;
import com.digiwin.mobile.mobileuibot.proxy.ai.model.DigiwinAiApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.ai.model.DigiwinAiOcrCarNumberResult;
import com.digiwin.mobile.mobileuibot.proxy.ocr.model.OcrData;

import java.util.List;

/**
 * @author wuyang
 * @date 20220215
 */
public interface OcrService {

    /**
     * ocr识别身份证
     *
     * @param flag 0(预设值)：不做身分证验真；1：若辨识出姓名及证号，则呼叫身分证验真服务
     * @param pic  pic是图档经过base64编码过
     * @return
     */
    List<OcrData> getIDCardByOcr(String flag, String pic);

    /**
     * ocr识别银行卡
     *
     * @param pic
     * @return
     */
    List<OcrData> getBankCardByOcr(String pic);

    /**
     * ocr识别车牌
     *
     * @param locale
     * @param iamUserToken
     * @param userId
     * @param tenantId
     * @param image
     * @return
     */
    DigiwinAiApiResponse<DigiwinAiOcrCarNumberResult> getOcrCarNumber(String locale, String iamUserToken, String userId, String tenantId, String image);

    /**
     * 在途宝识别车牌信息
     *
     * @param apiRequest
     * @param image
     * @return
     */
    OcrCarNumberResult getZtbOcrCarNumber(ApiRequestOcr apiRequest, String image);
}
