package com.digiwin.mobile.mobileuibot.proxy.ocr.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.PopPromptMsg;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTime;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePickerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.logistics.Logistics;
import com.digiwin.mobile.mobileuibot.core.component.logistics.LogisticsData;
import com.digiwin.mobile.mobileuibot.core.component.logistics.LogisticsEnum;
import com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.ocr.model.ApiRequestOcr;
import com.digiwin.mobile.mobileuibot.ocr.model.OcrCarNumberResult;
import com.digiwin.mobile.mobileuibot.proxy.ai.model.DigiwinAiApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.ai.model.DigiwinAiOcrCarNumber;
import com.digiwin.mobile.mobileuibot.proxy.ai.model.DigiwinAiOcrCarNumberResult;
import com.digiwin.mobile.mobileuibot.proxy.ai.service.DigiwinAiProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.ocr.model.OcrData;
import com.digiwin.mobile.mobileuibot.proxy.ocr.service.OcrService;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.DigestUtils;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author wuyang
 * @date 20220215
 */
@Service("ocrService")
public class OcrServiceImpl implements OcrService {
    private static Logger logger = LoggerFactory.getLogger(OcrServiceImpl.class);

    @Autowired
    private HttpService httpService;
    @Autowired
    private DigiwinAiProxyService digiwinAiProxyService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private ZhilinkService zhilinkService;

    @Override
    public List<OcrData> getIDCardByOcr(String flag, String pic) {
        String url = AppContext.getApiUrlSetting().getOcrApiUrl()
                + "/datasnap/rest/TServerMethods1/PictureRecognition/IDCard";
        Map<String, String> params = new HashMap<>(3);
        params.put("Token", getMD5String("DIGIWINAIKEY" + dateLong()).toUpperCase());
        params.put("Flag", flag);
        params.put("Data", pic);
        ResponseEntity<Map> responseEntity =
                httpService.doPost(url, new AthenaBasicHttpRequestHead(), JsonUtil.javaObjectToJsonString(params), Map.class);
        if (responseEntity != null && responseEntity.getStatusCode().is2xxSuccessful()) {
            Map map = ((List<Map>) responseEntity.getBody().get("result")).get(0);
            return mapToObject(map);
        }
        return null;
    }

    @Override
    public List<OcrData> getBankCardByOcr(String pic) {
        List<OcrData> ocrDataList = new ArrayList<>();
        String url = AppContext.getApiUrlSetting().getOcrApiUrl()
                + "/datasnap/rest/TServerMethods1/PictureRecognition/BankCard";
        Map<String, String> params = new HashMap<>(3);
        params.put("Token", getMD5String("DIGIWINAIKEY" + dateLong()).toUpperCase());
        params.put("Data", pic);
        ResponseEntity<Map> responseEntity =
                httpService.doPost(url, new AthenaBasicHttpRequestHead(), JsonUtil.javaObjectToJsonString(params), Map.class);
        if (responseEntity != null && responseEntity.getStatusCode().is2xxSuccessful()) {
            Map map = ((List<Map>) responseEntity.getBody().get("result")).get(0);
            return mapToObject(map);
        }
        return null;
    }

    @Override
    public DigiwinAiApiResponse<DigiwinAiOcrCarNumberResult> getOcrCarNumber(String locale, String iamUserToken, String userId, String tenantId, String image) {
        return digiwinAiProxyService.getOcrCarNumber(locale, iamUserToken, userId, tenantId, image);
    }

    @Override
    public OcrCarNumberResult getZtbOcrCarNumber(ApiRequestOcr apiRequest, String image) {
//        Map<String, Object> rawData = apiRequest.getRawData();
        String rawDataStr = apiRequest.getRawDataStr();
        logger.error("收的rawDataStr:", rawDataStr);
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String userId = apiRequest.getUserId();
        String tenantId = apiRequest.getTenantId();

        OcrCarNumberResult ocrCarNumberResult = new OcrCarNumberResult();

        // 调用Ai接口获取扫描的车牌号
        DigiwinAiApiResponse<DigiwinAiOcrCarNumberResult> digiwinAiApiResponse =
                this.getOcrCarNumber(locale, iamUserToken, userId, tenantId, image);

        if (digiwinAiApiResponse.getCode() != 0) {
            return buildErrorRusult("-1", ocrCarNumberResult,
                    localeService.getLanguageValue(locale, "识别失败，请重试"));
        }
        Map<String, Object> rawData = JSONObject.parseObject(rawDataStr, Map.class);
        Optional scanRequestIdOpt = Optional.ofNullable(rawData).map(item -> item.get("scanRequestId"));
        if (scanRequestIdOpt.isPresent() && rawData != null && ComponentSettingRequestIdEnum.OCR_ZTB_CAR_NUMBER.getReuqestId().equalsIgnoreCase((String) rawData.get("scanRequestId"))) {
            return buildZtbResult(digiwinAiApiResponse, rawData, apiRequest, ocrCarNumberResult);
        } else {
            //请求标识不是在途宝车牌识别标识，返回识别文字的dialog
            Map<String, Object> resultMap = new HashMap(1);
            resultMap.put("action", buildAction(locale, digiwinAiApiResponse));
            ocrCarNumberResult.setResultMap(resultMap);
            return ocrCarNumberResult;
        }
    }

    private OcrCarNumberResult buildZtbResult(DigiwinAiApiResponse<DigiwinAiOcrCarNumberResult>
                                                      digiwinAiApiResponse, Map<String, Object> rawData,
                                              ApiRequestOcr apiRequest, OcrCarNumberResult ocrCarNumberResult) {
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String userId = apiRequest.getUserId();
        String tenantId = apiRequest.getTenantId();
        List<DigiwinAiOcrCarNumber> digiwinAiOcrCarNumberList = digiwinAiApiResponse.getData().getWordsResult();
        if (!CollectionUtils.isEmpty(digiwinAiOcrCarNumberList)) {
            String taskNo = (String) rawData.get("task_no");
            //调用在途宝接口，加入租户，授权应用
            Map<String, Object> joinTenant = zhilinkService.joinTenant(iamUserToken, locale, taskNo, userId);
            if (!(Boolean) joinTenant.get("isSuccess")) {
                Action action = (Action) joinTenant.get("action");
                return buildErrorRusult("-1", ocrCarNumberResult, action.getToastMsg());
            }
            //当前业务场景只识别一个车辆码
            DigiwinAiOcrCarNumber carNumber = digiwinAiOcrCarNumberList.get(0);
            Map<String, Object> params = new HashMap<>(2);
            params.put("task_no", taskNo);
            params.put("license_plate_no", carNumber.getNumber());
            //TODO 判断识别的车牌号是否有对应司机
            Map<String, Object> codeScan = digiwinEspProxyService.taskTransportOcrScan(iamUserToken, tenantId, locale, params);
            if (CollectionUtils.isEmpty(codeScan)) {
                return buildErrorRusult("-2", ocrCarNumberResult,
                        localeService.getLanguageValue(locale, "当前车牌未有司机信息请联系司机维护处理"));
            }
            Map<String, Object> vehicleInfo = (Map<String, Object>) codeScan.get("vehicle_info");

            List<ActionSubmitParam> submitParamsList = JSONObject.parseObject(apiRequest.getSubmitParamsStr(), new TypeReference<List<ActionSubmitParam>>() {
            });
            JSONArray cargoInformation = JSONObject.parseArray(apiRequest.getCargoInformation());
            if (!CollectionUtils.isEmpty(codeScan) && !CollectionUtils.isEmpty(vehicleInfo)) {
                if (!CollectionUtils.isEmpty(submitParamsList)) {
                    for (ActionSubmitParam submitParam : submitParamsList) {
                        switch (submitParam.getType()) {
                            case Logistics.COMPONENT_TYPE:
                                List<LogisticsData> logisticsDataList = ModuleUtils.listMapToListObject((List<?>) submitParam.getParams(), LogisticsData.class);
                                for (LogisticsData data : logisticsDataList) {
                                    if (LogisticsEnum.SEND.getValue().equals(data.getType())) {
                                        codeScan.put("delivery_address_id", data.getId());
                                    } else if (LogisticsEnum.RECEIVER.getValue().equals(data.getType())) {
                                        codeScan.put("receipt_address_id", data.getId());
                                    }
                                }
                                break;
                            case InputDateTimePicker.COMPONENT_TYPE:
                                InputDateTimePicker inputDateTimePicker = JsonUtil.objectToJavaObject(submitParam.getParams(), InputDateTimePicker.class);
                                codeScan.put(submitParam.getSchema(), InputDateTime.getDateTypeDateStringByType(
                                        inputDateTimePicker.getDatetimeValue(),
                                        InputDateTimePickerTypeEnum.YEAR_MONTH_DATE.getType()));
                                break;
                            default:
                                break;
                        }
                    }
                }
                ocrCarNumberResult.setResultMap(zhilinkService.buildDriverCodeResultMap(new HashMap<>(2), rawData, codeScan, vehicleInfo, cargoInformation));
                ocrCarNumberResult.setCode("0");
                return ocrCarNumberResult;
            } else {
                return buildErrorRusult("-2", ocrCarNumberResult,
                        localeService.getLanguageValue(locale, "当前车牌未有司机信息请联系司机维护处理"));
            }
        }
        return buildErrorRusult("-1", ocrCarNumberResult,
                localeService.getLanguageValue(locale, "识别失败，请重试"));
    }

    private OcrCarNumberResult buildErrorRusult(String code, OcrCarNumberResult ocrCarNumberResult, String errorMsg) {
        ocrCarNumberResult.setErrorMsg(errorMsg);
        ocrCarNumberResult.setCode(code);
        return ocrCarNumberResult;
    }

    /**
     * buildAction
     *
     * @param locale
     * @param digiwinAiApiResponse
     * @return Action
     */
    private Action buildAction(String locale, DigiwinAiApiResponse<DigiwinAiOcrCarNumberResult> digiwinAiApiResponse) {
        Set<String> numberSet = digiwinAiApiResponse.getData().getWordsResult().stream().map(e -> e.getNumber()).collect(Collectors.toSet());
        String numbersStr = "当前识别车牌号：" + StringUtils.join(numberSet, "\r\n");
        Action action = new Action<>();
        action.setType(ActionTypeEnum.POP_PROMPT.getValue());
        PopPromptMsg popPromptMsg = new PopPromptMsg();
        popPromptMsg.setTitle(localeService.getLanguageValue(locale, "提示"));
        popPromptMsg.setContent(numbersStr);
        Button button = new Button();
        button.setName(localeService.getLanguageValue(locale, "确定"));
        button.setType(BottomButtonStyleEnum.STRESS.getValue());
        button.setAction(new Action(ActionTypeEnum.BACK.getValue()));
        popPromptMsg.setButtonList(Collections.singletonList(button));
        action.setPopPromptMsg(popPromptMsg);
        return action;
    }

    /**
     * 格林威治年月日时分
     *
     * @return
     */
    public static String dateLong() {
        Calendar cd = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm", Locale.US);
        // 设置时区为GMT
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        String str = sdf.format(cd.getTime());
        System.out.println(str);
        return str;
    }

    /**
     * MD5校验
     *
     * @param str
     * @return
     */
    public static String getMD5String(String str) {
        try {
            return DigestUtils.md5DigestAsHex(str.getBytes("utf-8"));
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<OcrData> mapToObject(Map map) {
        List<OcrData> ocrDataList = new ArrayList<>();
        Set<String> keys = map.keySet();
        for (String key : keys) {
            OcrData ocrData = new OcrData();
            ocrData.setField(key);
            ocrData.setFieldValue((String) map.get(key));
            ocrDataList.add(ocrData);
        }
        return ocrDataList;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(getMD5String("DIGIWINAIKEY" + dateLong()).toUpperCase());
    }
}
