package com.digiwin.mobile.mobileuibot.proxy.search.service;

import com.digiwin.mobile.mobileuibot.proxy.search.model.QaRequest;
import com.digiwin.mobile.mobileuibot.proxy.search.model.QaResponse;
import com.digiwin.mobile.mobileuibot.proxy.search.model.QuestionCompletionResponse;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;

import java.util.List;
import java.util.Map;

/**
 * 搜索的业务类接口
 * @author wuyang
 */
public interface SearchService {

    /**
     * NLP模糊查询
     * @param tenantId
     * @param question
     * @param ext
     * @param iamUserToken
     * @return
     */
    List<QuestionCompletionResponse> questionCompletion(String tenantId, String question, Map<String, String> ext, String iamUserToken);

    /**
     * NLP精准查询
     * @param request
     * @param iamUserToken
     * @return
     */
    QaResponse qa(QaRequest request, String iamUserToken);
}
