package com.digiwin.mobile.mobileuibot.proxy.search.service.impl;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.search.model.QaRequest;
import com.digiwin.mobile.mobileuibot.proxy.search.model.QaResponse;
import com.digiwin.mobile.mobileuibot.proxy.search.model.QuestionCompletionResponse;
import com.digiwin.mobile.mobileuibot.proxy.search.service.SearchService;
import com.fasterxml.jackson.core.type.TypeReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author wuyang
 */
@Service("searchService")
public class SearchServiceImpl implements SearchService {

    @Autowired
    private HttpService httpService;

    @Override
    public List<QuestionCompletionResponse> questionCompletion(String tenantId, String question, Map<String, String> ext, String iamUserToken) {
        String url = AppContext.getApiUrlSetting().getNlpBotUrl()
                + "/webot3/robot/api/v1/ai/question_completion";
        if(ext == null || ext.size() == 0){
            ext = new HashMap<>(1);
            ext.put("del", "");
        }
        Map<String, Object> params = new HashMap<>(3);
        params.put("tenant_id", tenantId);
        params.put("question", question);
        params.put("ext", ext);

        ResponseEntity<Map> responseEntity =
                httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(params), Map.class);
        if(responseEntity != null && responseEntity.getStatusCode().is2xxSuccessful()){
            return  JsonUtil.objectToJavaObject(responseEntity.getBody().get("data"), new TypeReference<List<QuestionCompletionResponse>>(){});
        }
        return null;
    }

    @Override
    public QaResponse qa(QaRequest request, String iamUserToken) {
        String url = AppContext.getApiUrlSetting().getNlpBotUrl()
                + "/webot3/robot/api/v1/ai/qa";

        ResponseEntity<Map> responseEntity =
                httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(request), Map.class);
        if(responseEntity != null && responseEntity.getStatusCode().is2xxSuccessful()){
            QaResponse qaResponse = new QaResponse();
            Map<String, Object> params = (Map<String, Object>) responseEntity.getBody().get("data");
            qaResponse.setUid((String) params.get("uid"));
            qaResponse.setMatchQuestion((String) params.get("match_question"));
            qaResponse.setAnswer((List<Map<String, Object>>) params.get("answer"));
            return qaResponse;
        }
        return null;
    }
}
