package com.digiwin.mobile.mobileuibot.proxy.semc.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.Size;
import java.util.List;
import java.util.Map;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ApplicationColumnReq {

    private Long id;

    /**
     * 上级id
     */
    private Long parentId;

    /**
     * 名称
     */
    @Size(max = 8,min = 1,message = "名称最大长度为8")
    private String name;

    /**
     * 状态：0：停运、1：启用
     */
    private Integer status;

    /**
     * 排序id
     */
    private Integer orderId;

    /**
     * 是否展示栏目名称 0:不展示名称，1：展示名称
     */
    private Integer isNameShow;

    /**
     * 自定义应用id
     */
    private Long customApplicationId;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 自定义应用集合
     */
    @Length(min = 1,message = "保存的应用不能为空")
    private List<SaveAppcationReq> customApplication;

    /**
     * 自定义id和类型集合
     */
    private List<Map> idAndSources;

    private Integer source;

}
