package com.digiwin.mobile.mobileuibot.proxy.semc.model;

import lombok.Data;

import java.io.Serializable;

/**
 * 数据源表实体
 *
 * @author yanfeng
 * @since 2024-03-18
 */
@Data
public class LabelSystemData implements Serializable {

    private static final long serialVersionUID = 3286481294507225180L;
    /**
     * 主键id
     */
    private Long id;

    /**
     * 数据源名称
     */
    private String name;

    /**
     * 数据源备注
     */
    private String remark;

    /**
     * 数据源分类（ 0-预设组件-三方待办、1-预设组件-三方报表、2-预设组件-新闻公告、
     * 3-自定义组件-作业集成、4-自定义组件-应用集成
     */
    private Integer dataCategory;

    /**
     * 源应用数据来源 1:b/s 表 2:c/s 表 3:预设表 4:IAM接口
     */
    private Integer dataType;

    /**
     * 应用编码
     */
    private String appCode;

    /**
     * 接入模式（0：混合云、1：纯云上）
     */
    private Integer dataModel;

    /**
     * 作业code
     */
    private String workCode;

    /**
     * 地中台系统名称
     */
    private String middleSystemName;

    /**
     * 地中台系统uid
     */
    private String middleSystemUid;

    /**
     * 有效状态 0:无效 1:有效
     */
    private Integer validStatus;

    /**
     * 三方应用接口地址
     */
    private String restUrl;

    /**
     * 作业回调地址
     */
    private String callBackUrl;

    /**
     * 是否需要自定义作业（0：不需要；1：需要）
     */
    private Integer isJob;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 创建者登录名称
     */
    private String createUserName;

    /**
     * 更新者登录名称
     */
    private String modifyUserName;

    /**
     * appId
     */
    private String appId;

    /**
     * 源应用名称
     */
    private String appName;

    /**
     * 作业名称
     */
    private String workName;


    /**
     * 应用类型 稳态、敏态
     */
    private String systemType;

    /**
     * SSO配置中的appToken
     */
    private String appToken;

    /**
     * 1:auth2授权码模式
     * 2：CAS模式
     */
    private Integer protocolType;

    /**
     * 数据来源 1:b/s 表 2:c/s 表 3:预设表应用 4:IAM接口应用
     */
    private Integer dataSource;

    /**
     * 是否需要实时获取sso地址
     * 0：不需要；1：需要
     */
    private Integer isNeedSsoUrl;

    /**
     * 是否需要定频刷新
     * 0：不需要；1：需要
     */
    private Integer isFixedRefresh;

}