package com.digiwin.mobile.mobileuibot.proxy.semc.model;


import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.io.Serializable;


@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class MobileDatasourceInfoVO {


    /**
     * 主键id
     */
    private Long id;

    /**
     * 名称
     */
    private String name;

    /**
     * 图标
     */
    private String icon;

    /**
     * 图标类型
     */
    private Integer iconType;

    /**
     * 状态 0:未发布 1:已发布 2:已失效
     */
    private Integer status;

    /**
     * 分类id
     */
    private Long classificationId;

    /**
     * 分类名称
     */
    private String classificationName;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 类型名称
     */
    private String typeName;

    /**
     * 备注
     */
    private String remarks;

    /**
     * sso应用主键id
     */
    private String applicationPrimaryId;

    /**
     * sso应用数据来源 1:b/s 表 2:c/s 表 3:预设表 4:IAM接口
     */
    private Integer applicationSource;

    /**
     * sso应用名称
     */
    private String applicationSourceName;

    /**
     * 创建日期
     */
    protected String createTime;

    /**
     * 更新日期
     */
    protected String modifyTime;

    /**
     * 创建者登录账号
     */
    protected String createUserId;

    /**
     * 更新者登录账号
     */
    protected String modifyUserId;

    /**
     *  是否需要自定义作业（0：不需要；1：需要）
     */
    private Integer isJob;

    /**
     * 作业回调地址
     */
    private String callBackUrl;

    /**
     * 作业code
     */
    private String workCode;

    /**
     * 是否有权限 false：无 true：有
     */
    private Boolean authFlag;
}

