package com.digiwin.mobile.mobileuibot.proxy.semc.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/***
 * 移动门户内容
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class MobilePortalInfoContentResp {

    /**
     * 栏目标题
     */
    private String title;

    /**
     * 是否展示栏目标题
     */
    private Integer isTitleShow;
    /**
     * 栏目id
     */
    private Long columnId;

    /**
     * 部件类型来源，0：租户部件，1：ISV部件
     */
    private Integer labelTypeSource;

    /**
     * 组件ID
     */
    private Long contentId;

    /**
     * 组件类型（0-预设组件-金刚区、1-预设组件-任务组件、2-预设组件-项目追踪组件、3-金刚球 4-轮播图、5-公告）
     */
    private Integer contentType;

    /**
     * 内容组件名称
     */
    private String contentName;
    /**
     * 是否显示文字（0：隐藏，1：显示）
     */
    private Integer isNameShow;

    /**
     * 父组件id
     */
    private Long parentId;

    /**
     * 组件内容属性值json
     */
    private String contentAttr;
}
