package com.digiwin.mobile.mobileuibot.proxy.semc.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class MobilePortalInfoResp {
    /**
     * 门户类型（0：门户布局；1：自定义页面布局）
     */
    private Integer portalType;

    /**
     * 自定义页面背景色
     */
    private String bgColor;

    /**
     * 自定义页面标题
     */
    private String title;

    /**
     * 权限被收回提示
     */
    private String recentlyMsg;
    /**
     * 组件
     */
    private List<MobilePortalInfoContentResp> contentList;

    /**
     * 老门户版本为0 默认门户版本为1
     */
    private int versionDefault;
}
