package com.digiwin.mobile.mobileuibot.proxy.semc.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * Created by changcong 21064
 * Date 2025/10/16 14:07
 * Description
 */
@Data
public class MobilePortalPreview {
    /**
     * 主键id
     */
    private Long id;

    /**
     * 默认门户（ 0：否 1：是）
     */
    private Integer defaultFlag;

    /**
     * 门户ID
     */
    private Long mobilePortalId;

    /**
     * 门户类型来源，0：租户门户，1：ISV门户
     */
    private Integer portalTypeSource;

    /**
     * 门户名称
     */
    private String name;


    /**
     * 门户类型（0：门户布局；1：自定义页面布局）
     */
    private Integer portalType;


    /**
     * 自定义页面标题
     */
    private String title;


    /**
     * 自定义页面背景色
     */
    private String bgColor;

    /**
     * 布局描述
     */
    private String portalDesc;

    /**
     * 布局状态（0：未发布；1：已发布
     */
    private Integer status;


    /**
     * 缩略图文件id
     */
    private String portalImgId;

    /**
     * 租户id
     */
    private String tenantId;


    /**
     * 创建者登录名称
     */
    protected String createUserName;

    /**
     * 更新者登录名称
     */
    protected String modifyUserName;

    /**
     * 二维码失效时间
     */
    protected Date endTime;



    /**
     * 布局内容集合jsonList
     */
    protected String portalContentList;

    private Integer versionDefault;
}
