package com.digiwin.mobile.mobileuibot.proxy.semc.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * <p>功能描述：金刚球</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PortalContentKingKongDistrictBall.java
 * @Author: wangjwc
 * @Date: created at 2025/9/17 11:17
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PortalContentKingKongDistrictBall implements Serializable {
    /**
     * 金刚球名称
     */
    private String ballName;
    /**
     * 金刚球图标类型 0:模板库 1:本地上传
     */
    private Integer iconType;

    /**
     * 金刚球图标或文件id
     */
    private String contentIcon;

    /**
     * 金刚球跳转链接
     */
    private String iconUrl;

    /**
     * 金刚球跳转类型（0-常用功能、1-自定义链接、2：应用/作业、3：自定义页面、4：公告 5、公告类型_0表示全部公告）
     */
    private Integer jumpType;

    /**
     * 金刚球跳转目标（pageID的值 或者 链接地址 或者自定义页面ID 或者 公告ID 或者公告类型ID）
     */
    private String jumpTarget;

    /**
     * 自定义应用id
     */
    private Long customApplicationId;
}
