package com.digiwin.mobile.mobileuibot.proxy.semc.model;

import lombok.Data;

import java.io.Serializable;

/**
 * 待办列表(TodoList)实体类
 *
 * @author yanfeng
 * @since 2024-03-18
 */
@Data
public class TodoField implements Serializable {

    private static final long serialVersionUID = 7007705555722457L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 系统名称:系统内填入SEMC，系统外填入系统名称
     */
    private String appName;

    /**
     * 待办人
     */
    private String toDoUser;

    /**
     * 显示名称
     */
    private String displayName;

    /**
     * 显示顺序
     */
    private Integer displayOrder;

    /**
     * 显示字段绑定数据的字段
     */
    private String bindingDataKey;

    /**
     * MAINTITLE（主标题）、SUBTITLE（副标题）、LABEL（文本 -- 拼接成字符串显示）
     */
    private String mobileType;
}