package com.digiwin.mobile.mobileuibot.proxy.semc.model;

import lombok.Data;

import java.io.Serializable;

/**
 * 待办列表(TodoList)实体类
 *
 * @author yanfeng
 * @since 2024-03-18
 */
@Data
public class TodoList implements Serializable {
    private static final long serialVersionUID = 966867023071645835L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 系统名称:系统内填入SEMC，系统外填入系统名称
     */
    private String appName;

    /**
     * 外部系统待办唯一标识
     */
    private String toDoId;

    /**
     * 待办 pc URL
     */
    private String toDoUrl;

    /**
     * 待办 移动 URL
     */
    private String mobileUrl;

    /**
     * 待办数据
     */
    private String toDoData;

    /**
     * 待办人
     */
    private String toDoUser;

    /**
     * 是否已办结 0 待办 1 已办结
     */
    private Integer isCompleted;

    /**
     * 是否已读 0 未读 1 已读
     */
    private Integer isRead;

    /**
     * 租户ID
     */
    private String tenantId;

    /**
     * 移动显示的主标题
     */
    private String mobileMainTitle;

    /**
     * 移动显示的副标题
     */
    private String mobileSubTitle;

    /**
     * 移动显示的文本
     */
    private String mobileLabel;

}
