package com.digiwin.mobile.mobileuibot.proxy.semc.model;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <p>功能描述：用户门户信息请求参数</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UserPortalInfoRequest.java
 * @Author: wangjwc
 * @Date: created at 2025/9/24 10:19
 */
@Data
@Accessors(chain = true)
public class UserPortalInfoRequest implements Serializable {
    private static final long serialVersionUID = -5398426196703400802L;
    /**
     * 主键id / 设计时Id / 移动侧预览表主键ID
     */
    private Long id;
    /**
     * 门户来源，0：租户门户，1：ISV门户
     */
    private Integer portalTypeSource = 0;

    /**
     * 客户端类型 PC端：0，移动端：1
     * ClientTypeTypeEnum
     */
    private Integer clientType = 0;


    // -------------------移动侧参数-------------------
    /**
     *  场景：0：正常用户访问、1：预览 ，默认0
     */
    private Integer scene = 0;

    /**
     * 门户类型（0：门户布局；1：自定义页面布局）
     */
    private Integer portalType = 0;
}