package com.digiwin.mobile.mobileuibot.proxy.semc.service;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.configparam.dto.MobilePortalCacheConfigParamDTO;
import com.digiwin.mobile.mobileuibot.news.model.ApiRequsetNews;
import com.digiwin.mobile.mobileuibot.news.model.MobileNewsAnnouncement;
import com.digiwin.mobile.mobileuibot.news.model.MobileNewsType;
import com.digiwin.mobile.mobileuibot.portal.model.ApiRequsetPortal;
import com.digiwin.mobile.mobileuibot.portal.model.UsePortalTypeResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.*;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：鼎捷SEMC代理服务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinCacProxyService
 * @Author: yanfeng
 * @Date: 2024-03-18
 */
public interface DigiwinSemcProxyService {

    String API_PREFIX = "/semc";

    /**
     * 获取三方待办列表数据
     *
     * @param clientId
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @return <a href="http://athena-devops-doclever.digiwincloud.com.cn/html/web/controller/share/share.html#65b8a1faa5a497000b26bb57">...</a>
     */
    List<LabelSystemData> getTripartiteToDoList(String clientId, String locale, String iamUserToken, String tenantId);

    /**
     * 判断是否有查看三方待办列表权限
     * 回参:response === 1 就代表有权限
     *
     * @param clientId
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @return
     */
    Boolean queryStatus(String clientId, String locale, String iamUserToken, String tenantId);

    /**
     * 三方待办
     * 获取某一个待办详情数据
     *
     * @param clientId
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @param appId        SSO配置中的AppId
     * @param appName      SSO配置中的应用名称
     * @param id           数据源id
     * @return
     * @Link <a href="http://athena-devops-doclever.digiwincloud.com.cn/html/web/controller/share/share.html#65fa8f2a5ed1db000bc5d96c">...</a>
     */
    TodoListResp selectTodoList(String clientId, String locale, String iamUserToken, String tenantId, String appId, String appName, String id);

    /**
     * 三方待办
     * 数据接口返回成功则状态改为已读
     *
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @param id           待办主键ID
     * @return
     */
    Boolean toRead(String locale, String iamUserToken, String tenantId, Integer id);

    /**
     * 获取待办(每刻)跳转的url
     *
     * @param iamUserToken
     * @param id           待办主键id
     * @return String
     * @author yanfeng
     * @link <a href="http://athena-devops-doclever.digiwincloud.com.cn/html/web/controller/share/share.html#6613abe55ed1db000bc5d9ea">...</a>
     */
    String getTodoListUrl(String iamUserToken, Integer id);

    /***
     * 获取公司别厂别
     * @param iamUserToken
     * @return
     */
    List<JSONObject> getCompanyFactory(String locale, String iamUserToken);

    /***
     * 保存公司别厂别
     * @param iamUserToken
     * @param company
     * @param factory
     * @return
     */
    Boolean saveCompanyFactory(String iamUserToken, String company, String factory);

    /**
     * 查询用户绿色智机权限
     *
     * @return
     */
    TopicPresetResp queryUserAuth(String locale, String iamUserToken);

    /**
     * 查询用户绿色智机模组和作业
     *
     * @return
     */
    List<TopicPresetResp> queryAllJob(List<String> caseIdList, String locale, String iamUserToken);

    /**
     * 获取移动门户组件
     */
//    List<MobilePortalInfoContentResp> getMobilePortalInfoContent(String locale, String iamUserToken);


    /**
     * 获取移动门户信息
     *
     * @param locale
     * @param iamUserToken
     * @param req
     * @return
     */
    MobilePortalInfoResp getMobilePortalInfo(String locale, String iamUserToken, UserPortalInfoRequest req);


    /**
     * 查询移动门户列表
     *
     * @param local
     * @param iamUserToken
     * @return
     */
    List<MobilePortalInfoItemResp> selectUserPortal(String local, String iamUserToken);

    /**
     * 查询用户选择门户类型
     *
     * @param local
     * @param iamUserToken
     * @return
     */
    UsePortalTypeResp getUserPortalType(String local, String iamUserToken);

    /**
     * 记录用户选择门户类型接口
     *
     * @param local
     * @param iamUserToken
     * @param portalType
     * @return
     */
    Boolean addPortalType(String local, String iamUserToken, Integer portalType, String portalId);

    /**
     * 添加使用记录
     *
     * @param locale
     * @param iamUserToken
     * @param dataId
     */
    Boolean addUserRecord(String locale, String iamUserToken, String dataId);

    /**
     * 检查用户门户权限
     *
     * @param locale
     * @param iamUserToken
     * @return
     */
    JSONObject checkPortalInfo(String locale, String iamUserToken, String dataId, Integer pageType);

    /**
     * 保存自定义金刚区
     *
     * @param mobilePortalId
     * @param contentResp
     * @param apiRequsetPortal
     * @return
     */
    JSONObject saveCustomDistrict(Long mobilePortalId, MobilePortalInfoContentResp contentResp, ApiRequsetPortal apiRequsetPortal);

    /**
     * 获取自定义金刚区
     *
     * @param mobilePortalId
     * @param contentId
     * @param apiRequsetPortal
     * @return
     */
    MobilePortalInfoContentResp getCustomDistrict(Long mobilePortalId, Long contentId, ApiRequsetPortal apiRequsetPortal);

    /**
     * 获取自定义分类应用
     *
     * @param apiRequsetPortal
     * @return
     */
    List<MobileClassificatonResp> getClassificationList(ApiRequsetPortal apiRequsetPortal);

    /**
     * 获取自定义分类应用--默认门户
     *
     * @param apiRequsetPortal
     * @return
     */
    List<MobileClassificatonRespNew> getClassificationListNew(ApiRequsetPortal apiRequsetPortal);

    /**
     * @param apiRequsetPortal
     */
    JSONObject saveApplicationColumn(ApiRequsetPortal apiRequsetPortal);

    JSONObject saveApplicationColumnNew(ApiRequsetPortal apiRequsetPortal);

    /**
     * 获取全部自定义栏目
     *
     * @param apiRequsetPortal
     * @return
     */
    List<ApplicationColumnReq> getApplicationColumnList(ApiRequsetPortal apiRequsetPortal);

    /**
     * 获取全部自定义栏目  默认门户
     *
     * @param apiRequsetPortal
     * @return
     */
    List<ApplicationColumnReq> getApplicationColumnListNew(ApiRequsetPortal apiRequsetPortal);

    /**
     * 获取单个栏目详情
     *
     * @param apiRequsetPortal
     * @return
     */
    MobileAppColumnResp getApplicationColumnDetail(ApiRequsetPortal apiRequsetPortal);

    /**
     * 获取单个栏目详情 --默认门户
     *
     * @param apiRequsetPortal
     * @return
     */
    //MobileAppColumnResp getApplicationColumnDetailNew(ApiRequsetPortal apiRequsetPortal);

    /**
     * 设置栏目排序
     *
     * @param apiRequsetPortal
     */
    JSONObject setColumnOrder(ApiRequsetPortal apiRequsetPortal);

    MobilePortalPreview getPreviewPortal(ApiRequest apiRequest, Long id);

    /**
     * 设置栏目排序 -- 默认门户
     *
     * @param apiRequsetPortal
     */
    JSONObject setColumnOrderNew(ApiRequsetPortal apiRequsetPortal);

    /**
     * 批量删除栏目卡
     *
     * @param apiRequsetPortal
     */
    JSONObject delColumn(ApiRequsetPortal apiRequsetPortal);

    /**
     * 批量删除栏目卡 -- 默认门户
     *
     * @param apiRequsetPortal
     */
    JSONObject delColumnNew(ApiRequsetPortal apiRequsetPortal);

    /**
     * 更新栏目转态
     *
     * @param apiRequsetPortal
     */
    JSONObject updateColumnStatus(ApiRequsetPortal apiRequsetPortal);

    /**
     * 更新栏目转态 --默认门户
     *
     * @param apiRequsetPortal
     */
    JSONObject updateColumnStatusNew(ApiRequsetPortal apiRequsetPortal);

    /**
     * 获取SSO全部参数的路径
     *
     * @param apiRequsetPortal
     * @return
     */
    MobileFullBackResp getFullCallBackUrl(ApiRequsetPortal apiRequsetPortal);

    /**
     * 查询租户设置的启动页配置接口
     *
     * @return
     */
    List<MobileStartSet> selectAppStartSet(String iamUserToken, String locale, String tenantId);

    /**
     * 分页查询用户公告列表
     *
     * @param apiRequsetNews
     * @return
     */
    MobileNewsAnnouncementPageResp queryMobileNewsListPage(ApiRequsetNews apiRequsetNews);

    /**
     * 查询用户端公告详情
     *
     * @param apiRequsetNews
     * @return
     */
    MobileNewsAnnouncement queryUserNewsDetail(ApiRequsetNews apiRequsetNews);

    JSONObject validateNews(ApiRequsetNews apiRequsetNews);

    List<MobileNewsType> queryNewsTypeList(ApiRequsetNews apiRequsetNews);

    Boolean readNews(ApiRequsetNews apiRequsetNews);

    /**
     * 公告点赞
     * @param apiRequsetNews
     * @return 0：表示点赞成功，1：表示重复点赞，2：公告不存在或者无权限
     */
    Integer likeNews(ApiRequsetNews apiRequsetNews);


    /**
     * 公告取消点赞
     * @param apiRequsetNews
     * @return 0：表示取消点赞成功，1：表示没有点赞记录，2：公告不存在或者无权限
     */
    Integer cancelLikeNews(ApiRequsetNews apiRequsetNews);

    /**
     * 公告收藏
     *
     * @return 0：表示收藏成功，1：表示重复收藏，2：公告不存在或者无权限，3：收藏失败
     */
    Integer favoriteNews(ApiRequsetNews apiRequsetNews);

    /**
     * 公告取消收藏
     *
     * @return 0：表示取消收藏成功，1：表示没有收藏记录（失败），2：取消收藏失败
     */
    Integer cancelFavoriteNews(ApiRequsetNews apiRequsetNews);

    /**
     * 我的公告收藏列表
     */
    MyNewsAnnouncementFavoritePageResp myFavoriteNewsList(ApiRequsetNews apiRequsetNews);


    /**
     * 校验公告类型是否存在
     *
     * @param apiRequsetNews             请求入参
     * @param athenaBasicHttpRequestHead 请求头
     * @return 返回
     */
    Boolean validNewsType(ApiRequsetNews apiRequsetNews, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead);

    /**
     * 获取移动端门户缓存配置参数
     */
    MobilePortalCacheConfigParamDTO getMobilePortalCacheConfigParam(AthenaBasicHttpRequestHead athenaBasicHttpRequestHead);

    /**
     * 获取通用参数
     */
    Object getCommonConfig(String key, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead);

    /**
     * 校验当前用户是否有自定义应用的权限
     *
     * @param apiRequsetPortal 请求参数
     * @return 返回
     */
    List<ValidMobileAppAuthResp> validUserAppAuth(ApiRequsetPortal apiRequsetPortal);

    /**
     * 获取sso免登链接
     *
     * @param locale
     * @param iamUserToken
     * @param params
     * @return
     */
    JSONObject getSsoUrl(String locale, String iamUserToken, Map<String, Object> params);

    /**
     * 获取设备绑定配置信息
     * @return 设备绑定配置信息
     */
    DeviceBindConfig deviceBindConfig();
    /**
     * 获取设备绑定列表
     * @param iamUserToken 用户token
     * @return 设备绑定列表
     */
    List<DeviceBindResp> deviceBindList(String iamUserToken);

    /**
     * 设备绑定认证
     * @param deviceBindReq 设备绑定请求参数
     * @return 设备绑定认证结果
     */
    DeviceBindAuth deviceBindAuth(DeviceBindReq deviceBindReq);

    /**
     * 账号设备首次绑定
     * @param deviceBindReq 设备绑定请求参数
     * @return 设备绑定结果
     */
    Boolean deviceBindAuto(DeviceBindReq deviceBindReq);
}
