package com.digiwin.mobile.mobileuibot.proxy.semc.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.configparam.dto.MobilePortalCacheConfigParamDTO;
import com.digiwin.mobile.mobileuibot.news.model.ApiRequsetNews;
import com.digiwin.mobile.mobileuibot.news.model.MobileNewsAnnouncement;
import com.digiwin.mobile.mobileuibot.news.model.MobileNewsType;
import com.digiwin.mobile.mobileuibot.portal.model.ApiRequsetPortal;
import com.digiwin.mobile.mobileuibot.portal.model.UsePortalTypeResp;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @author yanfeng
 * @date 2024/3/18
 */
@Slf4j
@Service("digiwinSemcProxyServiceImpl")
public class DigiwinSemcProxyServiceImpl implements DigiwinSemcProxyService {

    private final HttpService httpService;

    private final static String LOCAL = "http://localhost:8080";

    public DigiwinSemcProxyServiceImpl(HttpService httpService) {
        this.httpService = httpService;
    }

    @Override
    public MobilePortalPreview getPreviewPortal(ApiRequest apiRequest,Long id){
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX
                + "/mobile/portal//info/getPreviewPortal";
        Map<String, Object> uriVariables = new HashMap<>(1);
        //数据类型（0：待办、1：三方报表、2：新闻公告、3：邮件、4：常用、5：收藏、6：全局资讯、7：绩效、8：作业工作台）
        uriVariables.put("id", id);

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<MobilePortalPreview>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<MobilePortalPreview>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<MobilePortalPreview>> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId())
                , JsonUtil.javaObjectToJsonString(uriVariables), responseType);
        return responseEntity.getBody().getResponse();
    }

    @Override
    public List<LabelSystemData> getTripartiteToDoList(String clientId, String locale, String iamUserToken, String tenantId) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX
                + "/label/system/data/systemList";

        Map<String, Object> uriVariables = new HashMap<>(1);
        //数据类型（0：待办、1：三方报表、2：新闻公告、3：邮件、4：常用、5：收藏、6：全局资讯、7：绩效、8：作业工作台）
        uriVariables.put("dataType", 0);

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<LabelSystemData>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<LabelSystemData>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<List<LabelSystemData>>> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId)
                , JsonUtil.javaObjectToJsonString(uriVariables), responseType);

        return responseEntity.getStatusCode().is2xxSuccessful() ? Objects.requireNonNull(responseEntity.getBody()).getResponse() : Collections.emptyList();
    }

    @Override
    public Boolean queryStatus(String clientId, String locale, String iamUserToken, String tenantId) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX
                + "/layout/component/queryStatus?dataType=0";


        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Object>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Object>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Object>> responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId)
                , responseType);
        if (responseEntity.getStatusCode().is2xxSuccessful() && ObjectUtils.isNotEmpty(responseEntity.getBody())) {
            int i = Integer.parseInt(String.valueOf(responseEntity.getBody().getResponse()));
            return i == 1;
        }
        return false;
    }

    @Override
    public TodoListResp selectTodoList(String clientId, String locale, String iamUserToken, String tenantId, String appId, String appName, String id) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX
                + "/todoList/todo/selectTodoList";

        Map<String, Object> uriVariables = new HashMap<>(4);
        uriVariables.put("id", id);
        uriVariables.put("appId", appId);
        uriVariables.put("appName", appName);
        uriVariables.put("pageNum", 1);
        uriVariables.put("pageSize", 999);

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Map<String, Object>>> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId)
                , JsonUtil.javaObjectToJsonString(uriVariables), responseType);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            if (ObjectUtils.isNotEmpty(responseEntity.getBody().getResponse())) {
                return JsonUtil.objectToJavaObject(responseEntity.getBody().getResponse().get("data"), TodoListResp.class);
            }
        }
        return null;
    }

    @Override
    public Boolean toRead(String locale, String iamUserToken, String tenantId, Integer id) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX
                + "/todoList/todo/toRead";

        Map<String, Object> uriVariables = new HashMap<>(1);
        uriVariables.put("id", id);

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Object>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Object>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Object>> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId)
                , JsonUtil.javaObjectToJsonString(uriVariables), responseType);

        return responseEntity.getStatusCode().is2xxSuccessful();
    }

    @Override
    public String getTodoListUrl(String iamUserToken, Integer id) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX
                + "/todoList/getTodoListUrl";
        Map<String, Object> uriVariables = new HashMap<>(1);
        uriVariables.put("id", id);

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Object>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Object>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Object>> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken)
                , JsonUtil.javaObjectToJsonString(uriVariables), responseType);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            Map<String, String> response = (Map<String, String>) responseEntity.getBody().getResponse();
            return String.valueOf(response.get("toDoMobileUrl"));
        }
        return "";
    }


    @Override
    public List<JSONObject> getCompanyFactory(String locale, String iamUserToken) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX
                + "/cloudNavigation/getCompanyFactoryList";
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<JSONObject>>> responseType = new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<JSONObject>>>() {
        };
        try {
            ResponseEntity<DigiwinAthenaApiResponse<List<JSONObject>>> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, iamUserToken), "", responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                List<JSONObject> response = responseEntity.getBody().getResponse();
                return response;
            }
        } catch (Exception e) {
            log.error("semc getCompanyFactory  error{}", e.getMessage());
            return null;
        }
        return null;
    }

    @Override
    public Boolean saveCompanyFactory(String iamUserToken, String company, String factory) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX
                + "/cloudNavigation/saveOrUpdateCompanyFactory";
        Map<String, Object> map = new HashMap<>();
        map.put("company", company);
        map.put("factory", factory);
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Object>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Object>>() {
                };
        try {
            ResponseEntity<DigiwinAthenaApiResponse<Object>> responseEntity =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(map), responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return true;
            }
        } catch (Exception e) {
            log.error("semc saveOrUpdateCompanyFactory  error{}", e.getMessage());
            return false;
        }
        return false;
    }


    @Override
    public TopicPresetResp queryUserAuth(String locale, String iamUserToken) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX
                + "/topic/queryUserAuth";
        Map<String, Object> uriVariables = new HashMap<>(1);
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        TopicPresetResp authResp = new TopicPresetResp();
        authResp.setIsHavePreset(false);
        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<Object>> responseType =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<Object>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<Object>> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, iamUserToken)
                    , JsonUtil.javaObjectToJsonString(uriVariables), responseType);
            log.debug("semc/topic/queryUserAuth resp{}", JSONObject.toJSONString(responseEntity));
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                authResp = JSONObject.parseObject(JSONObject.toJSONString(responseEntity.getBody().getResponse()), TopicPresetResp.class);
                return authResp;
            }
        } catch (Exception e) {
            log.error("semc queryUserAuth  error{}", e.getMessage());
            return authResp;
        }
        return authResp;
    }

    @Override
    public List<TopicPresetResp> queryAllJob(List<String> caseIdList, String locale, String iamUserToken) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX
                + "/topic/job/queryAllJob";
        Map<String, Object> uriVariables = new HashMap<>(1);
        uriVariables.put("caseIdList", caseIdList);
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<Object>> responseType =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<Object>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<Object>> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, iamUserToken)
                    , JsonUtil.javaObjectToJsonString(uriVariables), responseType);
            log.debug("semc/topic/job/queryAllJob resp{}", JSONObject.toJSONString(responseEntity));
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                List<TopicPresetResp> topicPresetRespList = JSONArray.parseArray(JSONObject.toJSONString(responseEntity.getBody().getResponse()).toString(), TopicPresetResp.class);
                return topicPresetRespList;
            }
        } catch (Exception e) {
            log.error("semc/topic/job/queryAllJob  error{}", e.getMessage());
            return null;
        }
        return null;
    }

    @Override
    public MobilePortalInfoResp getMobilePortalInfo(String locale, String iamUserToken, UserPortalInfoRequest req) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + API_PREFIX
                + "/portal/info/getPortalInfo";
        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>> responseTyep =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<JSONObject>> response =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, iamUserToken),
                            JsonUtil.javaObjectToJsonString(req), responseTyep);
            if (response.getStatusCode().is2xxSuccessful()) {
                return response.getBody().getResponse().toJavaObject(MobilePortalInfoResp.class);
            }
        } catch (Exception e) {
            log.error("/mobilePortal/getMobilePortalInfo error{}", e.getMessage());
        }
        return null;
    }

    /**
     * 查询移动门户列表
     *
     * @param local
     * @param iamUserToken
     * @return
     */
    @Override
    public List<MobilePortalInfoItemResp> selectUserPortal(String local, String iamUserToken) {
        //TODO 记得修改为服务
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/mobile/portal/info/userAuth/selectUserPortal";
        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONArray>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONArray>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<JSONArray>> responseEntity =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead(local, iamUserToken), parameterizedTypeReference);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                JSONArray response = responseEntity.getBody().getResponse();
                String s = JsonUtil.javaObjectToJsonString(response);
                List<MobilePortalInfoItemResp> respList = JSONArray.parseArray(s, MobilePortalInfoItemResp.class);
                return respList;
            }
        } catch (Exception e) {
            log.error("/mobile/portal/info/userAuth/selectUserPortal error{}", e.getMessage());
        }
        return null;
    }

    /**
     * 查询用户选择门户类型
     *
     * @param local
     * @param iamUserToken
     * @return
     */
    @Override
    public UsePortalTypeResp getUserPortalType(String local, String iamUserToken) {
        UsePortalTypeResp result = new UsePortalTypeResp();
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/mobile/portal/getUserPortalType";
        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<JSONObject>> response =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead(local, iamUserToken), parameterizedTypeReference);
            if (response.getStatusCode().is2xxSuccessful()) {
                response.getBody().getResponse();
                String s = JsonUtil.javaObjectToJsonString(response.getBody().getResponse());
                result = JSONObject.parseObject(s, UsePortalTypeResp.class);
                return result;
            }
        } catch (Exception e) {
            log.error("/mobile/portal/getUserPortalType error{}", e.getMessage());
        }
        return result;
    }

    /**
     * 记录用户选择门户类型接口
     *
     * @param local
     * @param iamUserToken
     * @param portalType
     * @return
     */
    @Override
    public Boolean addPortalType(String local, String iamUserToken, Integer portalType, String portalId) {
        Boolean flag = false;
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/mobile/portal/addPortalType";
        HashMap<String, Object> map = new HashMap<>();
        map.put("portalType", portalType);
        map.put("mobilePortalId", portalId);
        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<Object>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<Object>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<Object>> response =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead(local, iamUserToken), JsonUtil.javaObjectToJsonString(map), parameterizedTypeReference);
            if (response.getStatusCode().is2xxSuccessful()) {
                String s = JsonUtil.javaObjectToJsonString(response.getBody().getResponse());
                flag = JsonUtil.jsonStringToObject(s, Boolean.class);
                return flag;
            }
        } catch (Exception e) {
            log.error("/mobile/portal/addPortalType error{}", e.getMessage());
        }
        return flag;
    }

    @Override
    public Boolean addUserRecord(String locale, String iamUserToken, String dataId) {
        Boolean result = false;
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/mobile/portal/addUserRecord";
        Long id = Long.valueOf(dataId);
        Map<String, Long> map = new HashMap<>();
        map.put("mobilePortalId", id);
        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<Object>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<Object>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<Object>> response =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, iamUserToken), JsonUtil.javaObjectToJsonString(map), parameterizedTypeReference);
            if (response.getStatusCode().is2xxSuccessful()) {
                result = (Boolean) response.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("/mobile/portal/addUserRecord error{}", e.getMessage());
        }
        return result;
    }

    @Override
    public JSONObject checkPortalInfo(String locale, String iamUserToken, String dataId, Integer pageType) {
        JSONObject result = new JSONObject();
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/mobile/portal/info/checkPortalInfo";
        Long id = Long.valueOf(dataId);
        Map<String, String> map = new HashMap<>();
        map.put("id", id + "");
        //页面类型（0：门户布局；1：自定义页面布局）,默认0
        if (null == pageType) {
            pageType = 0;
        }
        map.put("portalType", pageType + "");
        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<JSONObject>> response =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, iamUserToken), JsonUtil.javaObjectToJsonString(map), parameterizedTypeReference);
            if (response.getStatusCode().is2xxSuccessful()) {
                result = response.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("/mobile/portal/info/checkPortalInfo error{}", e.getMessage());
        }
        return result;
    }


    @Override
    public JSONObject saveCustomDistrict(Long mobilePortalId, MobilePortalInfoContentResp contentResp, ApiRequsetPortal apiRequsetPortal) {
        JSONObject result = new JSONObject();
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/mobile/portal/saveCustomDistrict";
        Map<String, Object> body = new HashMap<>();
        body.put("mobilePortalId", mobilePortalId);
        body.put("mobilePortalInfoContentResp", contentResp);
        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<JSONObject>> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(apiRequsetPortal.getLocale(), apiRequsetPortal.getIamUserToken()),
                    JsonUtil.javaObjectToJsonString(body), parameterizedTypeReference);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                result = responseEntity.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("/mobile/portal/saveCustomDistrict error{}", e.getMessage());
        }
        return result;
    }


    @Override
    public MobilePortalInfoContentResp getCustomDistrict(Long mobilePortalId, Long contentId, ApiRequsetPortal apiRequsetPortal) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/mobile/portal/getCustomDistrict";
        Map<String, Object> body = new HashMap<>();
        body.put("mobilePortalId", mobilePortalId);
        body.put("contentId", contentId);
        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<MobilePortalInfoContentResp>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<MobilePortalInfoContentResp>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<MobilePortalInfoContentResp>> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(apiRequsetPortal.getLocale(), apiRequsetPortal.getIamUserToken()),
                    JsonUtil.javaObjectToJsonString(body), parameterizedTypeReference);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return responseEntity.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("/mobile/portal/getCustomDistrict error{}", e.getMessage());
        }
        return null;
    }

    @Override
    public List<MobileClassificatonResp> getClassificationList(ApiRequsetPortal apiRequsetPortal) {
        //todo
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/mobile/application/class/getClassificationList";
        Map<String, Object> body = new HashMap<>();
        //是否需要查询全部的数据，true：查询所有分类，false：需要根据用户已选的分类过滤
        body.put("isAll", apiRequsetPortal.getIsAll());
        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<List<MobileClassificatonResp>>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<MobileClassificatonResp>>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<List<MobileClassificatonResp>>> responseEntity =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead(apiRequsetPortal.getLocale(), apiRequsetPortal.getIamUserToken()), JsonUtil.javaObjectToJsonString(body), parameterizedTypeReference);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return responseEntity.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("/mobile/application/class/getClassificationList error{}", e.getMessage());
        }
        return null;
    }

    @Override
    public List<MobileClassificatonRespNew> getClassificationListNew(ApiRequsetPortal apiRequsetPortal) {
        //todo
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/mobile/application/class/getClassificationList";
        Map<String, Object> body = new HashMap<>();
        //是否需要查询全部的数据，true：查询所有分类，false：需要根据用户已选的分类过滤
        body.put("isAll", apiRequsetPortal.getIsAll());
        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<List<MobileClassificatonRespNew>>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<MobileClassificatonRespNew>>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<List<MobileClassificatonRespNew>>> responseEntity =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead(apiRequsetPortal.getLocale(), apiRequsetPortal.getIamUserToken()), JsonUtil.javaObjectToJsonString(body), parameterizedTypeReference);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return responseEntity.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("/mobile/application/class/getClassificationListNew error{}", e.getMessage());
        }
        return null;
    }

    @Override
    public JSONObject saveApplicationColumn(ApiRequsetPortal apiRequsetPortal) {
        //todo
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/mobile/portal/saveApplicationColumn";
        ApplicationColumnReq applicationColumnReq = apiRequsetPortal.getApplicationColumnReq();

        Map<String, Object> map = new HashMap<>();
        map.put("applicationColumnReq", apiRequsetPortal.getApplicationColumnReq());
        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<JSONObject>> responseEntity =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead(apiRequsetPortal.getLocale(), apiRequsetPortal.getIamUserToken()),
                            JsonUtil.javaObjectToJsonString(applicationColumnReq), parameterizedTypeReference);
            if (responseEntity.getStatusCode().is2xxSuccessful() && responseEntity.getBody().getStatus().equals(200)) {
                return responseEntity.getBody().getResponse();
            } else {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("error", responseEntity.getBody().getErrorMessage());
                return jsonObject;
            }
        } catch (Exception e) {
            log.error("/mobile/portal/saveApplicationColumn error {}", e.getMessage());
        }
        return null;
    }

    @Override
    public JSONObject saveApplicationColumnNew(ApiRequsetPortal apiRequsetPortal) {
        //todo
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/mobile/portal/saveApplicationColumnNew";
        ApplicationColumnReq applicationColumnReq = apiRequsetPortal.getApplicationColumnReq();
        Map<String, Object> map = new HashMap<>();
        map.put("applicationColumnReq", apiRequsetPortal.getApplicationColumnReq());
        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<JSONObject>> responseEntity =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead(apiRequsetPortal.getLocale(), apiRequsetPortal.getIamUserToken()),
                            JsonUtil.javaObjectToJsonString(applicationColumnReq), parameterizedTypeReference);
            if (responseEntity.getStatusCode().is2xxSuccessful() && responseEntity.getBody().getStatus().equals(200)) {
                return responseEntity.getBody().getResponse();
            } else {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("error", responseEntity.getBody().getErrorMessage());
                return jsonObject;
            }
        } catch (Exception e) {
            log.error("/mobile/portal/saveApplicationColumnNew error {}", e.getMessage());
        }
        return null;
    }

    @Override
    public List<ApplicationColumnReq> getApplicationColumnList(ApiRequsetPortal apiRequsetPortal) {
        //todo
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/mobile/portal/getApplicationColumnList";
        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<List<ApplicationColumnReq>>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<ApplicationColumnReq>>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<List<ApplicationColumnReq>>> responseEntity =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead(apiRequsetPortal.getLocale(), apiRequsetPortal.getIamUserToken()),
                            parameterizedTypeReference);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                List<ApplicationColumnReq> response = responseEntity.getBody().getResponse();
                return response;
            }
        } catch (Exception e) {
            log.error("/mobile/portal/getApplicationColumnList error {}", e.getMessage());
        }
        return null;
    }

    @Override
    public List<ApplicationColumnReq> getApplicationColumnListNew(ApiRequsetPortal apiRequsetPortal) {
        //todo
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/mobile/portal/getApplicationColumnListNew";
        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<List<ApplicationColumnReq>>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<ApplicationColumnReq>>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<List<ApplicationColumnReq>>> responseEntity =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead(apiRequsetPortal.getLocale(), apiRequsetPortal.getIamUserToken()),
                            parameterizedTypeReference);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                List<ApplicationColumnReq> response = responseEntity.getBody().getResponse();
                return response;
            }
        } catch (Exception e) {
            log.error("/mobile/portal/getApplicationColumnListNew error {}", e.getMessage());
        }
        return null;
    }

    @Override
    public MobileAppColumnResp getApplicationColumnDetail(ApiRequsetPortal apiRequsetPortal) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/mobile/portal/getApplicationColumnDetail";
        Long id = apiRequsetPortal.getApplicationColumnReq().getId();
        Map<String, Object> map = new HashMap<>();
        map.put("id", id);
        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<MobileAppColumnResp>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<MobileAppColumnResp>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<MobileAppColumnResp>> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", apiRequsetPortal.getLocale(), apiRequsetPortal.getIamUserToken(), null),
                    JsonUtil.javaObjectToJsonString(map), parameterizedTypeReference);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                MobileAppColumnResp response = responseEntity.getBody().getResponse();
                return response;
            }
        } catch (Exception e) {
            log.error("/mobile/portal/getApplicationColumnDetail error {}", e.getMessage());
        }
        return null;
    }

//    @Override
//    public MobileAppColumnResp getApplicationColumnDetailNew(ApiRequsetPortal apiRequsetPortal) {
//        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/mobile/portal/getApplicationColumnDetailNew";
//        Long id = apiRequsetPortal.getApplicationColumnReq().getId();
//        Map<String, Object> map = new HashMap<>();
//        map.put("id", id);
//        if (0 == apiRequsetPortal.getApplicationColumnReq().getSource()) {
//            try {
//                ParameterizedTypeReference<DigiwinAthenaApiResponse<MobileAppColumnResp>> parameterizedTypeReference =
//                        new ParameterizedTypeReference<DigiwinAthenaApiResponse<MobileAppColumnResp>>() {
//                        };
//                ResponseEntity<DigiwinAthenaApiResponse<MobileAppColumnResp>> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", apiRequsetPortal.getLocale(), apiRequsetPortal.getIamUserToken(), null),
//                        JsonUtil.javaObjectToJsonString(map), parameterizedTypeReference);
//                if (responseEntity.getStatusCode().is2xxSuccessful()) {
//                    MobileAppColumnResp response = responseEntity.getBody().getResponse();
//                    return response;
//                }
//            } catch (Exception e) {
//                log.error("/mobile/portal/getApplicationColumnDetailNew error {}", e.getMessage());
//            }
//            return null;
//        }else if (1 == apiRequsetPortal.getApplicationColumnReq().getSource()){
//            get
//        }
//    }

    @Override
    public JSONObject setColumnOrder(ApiRequsetPortal apiRequsetPortal) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/mobile/portal/setColumnOrder";
        List<Long> columnIds = apiRequsetPortal.getColumnIds();
        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<JSONObject>> responseEntity =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", apiRequsetPortal.getLocale(), apiRequsetPortal.getIamUserToken(), null),
                            JsonUtil.javaObjectToJsonString(columnIds), parameterizedTypeReference);
            if (responseEntity.getStatusCode().is2xxSuccessful() && responseEntity.getBody().getStatus().equals(HttpStatus.OK.value())) {
                return responseEntity.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("/mobile/portal/setColumnOrder error {}", e.getMessage());
        }
        return null;
    }

    @Override
    public JSONObject setColumnOrderNew(ApiRequsetPortal apiRequsetPortal) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/mobile/portal/setColumnOrderNew";
        List<Long> columnIds = apiRequsetPortal.getColumnIds();
        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<JSONObject>> responseEntity =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", apiRequsetPortal.getLocale(), apiRequsetPortal.getIamUserToken(), null),
                            JsonUtil.javaObjectToJsonString(columnIds), parameterizedTypeReference);
            if (responseEntity.getStatusCode().is2xxSuccessful() && responseEntity.getBody().getStatus().equals(HttpStatus.OK.value())) {
                return responseEntity.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("/mobile/portal/setColumnOrderNew error {}", e.getMessage());
        }
        return null;
    }

    @Override
    public JSONObject delColumn(ApiRequsetPortal apiRequsetPortal) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/mobile/portal/delColumn";
        List<Long> columnIds = apiRequsetPortal.getColumnIds();
        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<JSONObject>> responseEntity =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", apiRequsetPortal.getLocale(), apiRequsetPortal.getIamUserToken(), null), JsonUtil.javaObjectToJsonString(columnIds), parameterizedTypeReference);
            if (responseEntity.getStatusCode().is2xxSuccessful() && responseEntity.getBody().getStatus().equals(HttpStatus.OK.value())) {
                return responseEntity.getBody().getResponse();
            } else {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("error", responseEntity.getBody().getErrorMessage());
                return jsonObject;
            }
        } catch (Exception e) {
            log.error("/mobile/portal/delColumn error{}", e.getMessage());
        }
        return null;
    }

    @Override
    public JSONObject delColumnNew(ApiRequsetPortal apiRequsetPortal) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/mobile/portal/delColumnNew";
        List<Long> columnIds = apiRequsetPortal.getColumnIds();
        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<JSONObject>> responseEntity =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", apiRequsetPortal.getLocale(), apiRequsetPortal.getIamUserToken(), null), JsonUtil.javaObjectToJsonString(columnIds), parameterizedTypeReference);
            if (responseEntity.getStatusCode().is2xxSuccessful() && responseEntity.getBody().getStatus().equals(HttpStatus.OK.value())) {
                return responseEntity.getBody().getResponse();
            } else {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("error", responseEntity.getBody().getErrorMessage());
                return jsonObject;
            }
        } catch (Exception e) {
            log.error("/mobile/portal/delColumnNew error{}", e.getMessage());
        }
        return null;
    }

    @Override
    public JSONObject updateColumnStatus(ApiRequsetPortal apiRequsetPortal) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/mobile/portal/updateColumnStatus";
//        Map<String,Object> map = new HashMap<>();
//        map.put("applicationColumnReq",apiRequsetPortal.getApplicationColumnReq());
        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<JSONObject>> responseEntity =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", apiRequsetPortal.getLocale(), apiRequsetPortal.getIamUserToken(), null), JsonUtil.javaObjectToJsonString(apiRequsetPortal.getApplicationColumnReq()), parameterizedTypeReference);
            if (responseEntity.getStatusCode().is2xxSuccessful() && responseEntity.getBody().getStatus().equals(HttpStatus.OK.value())) {
                return responseEntity.getBody().getResponse();
            } else {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("error", responseEntity.getBody().getErrorMessage());
                return jsonObject;
            }
        } catch (Exception e) {
            log.error("/mobile/portal/updateColumnStatus error{}", e.getMessage());
        }
        return null;
    }

    @Override
    public JSONObject updateColumnStatusNew(ApiRequsetPortal apiRequsetPortal) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/mobile/portal/updateColumnStatusNew";
//        Map<String,Object> map = new HashMap<>();
//        map.put("applicationColumnReq",apiRequsetPortal.getApplicationColumnReq());
        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<JSONObject>> responseEntity =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", apiRequsetPortal.getLocale(), apiRequsetPortal.getIamUserToken(), null), JsonUtil.javaObjectToJsonString(apiRequsetPortal.getApplicationColumnReq()), parameterizedTypeReference);
            if (responseEntity.getStatusCode().is2xxSuccessful() && responseEntity.getBody().getStatus().equals(HttpStatus.OK.value())) {
                return responseEntity.getBody().getResponse();
            } else {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("error", responseEntity.getBody().getErrorMessage());
                return jsonObject;
            }
        } catch (Exception e) {
            log.error("/mobile/portal/updateColumnStatusNew error{}", e.getMessage());
        }
        return null;
    }

    @Override
    public MobileFullBackResp getFullCallBackUrl(ApiRequsetPortal apiRequsetPortal) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/mobile/portal/getFullCallBackUrl";
        Map<String, Object> map = new HashMap<>();
        map.put("applicationPrimaryId", apiRequsetPortal.getApplicationPrimaryId());
        map.put("callBackUrl", apiRequsetPortal.getCallBackUrl());
        map.put("customApplicationId", apiRequsetPortal.getCustomApplicationId());
        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<MobileFullBackResp>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<MobileFullBackResp>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<MobileFullBackResp>> responseEntity =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", apiRequsetPortal.getLocale(), apiRequsetPortal.getIamUserToken(), null), JsonUtil.javaObjectToJsonString(map), parameterizedTypeReference);
            if (responseEntity.getStatusCode().is2xxSuccessful() && responseEntity.getBody().getStatus().equals(HttpStatus.OK.value())) {
                return responseEntity.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("/mobile/portal/getFullCallBackUrl error{}", e.getMessage());
        }
        return null;
    }

    @Override
    public List<MobileStartSet> selectAppStartSet(String iamUserToken, String locale, String tenantId) {
        List<MobileStartSet> mobileStartSetList = new ArrayList<>();
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/mobile/start/set/selectAppStartSet";
        try {
            Map<String, Object> map = new HashMap<>();
            ParameterizedTypeReference<DigiwinAthenaApiResponse<List<MobileStartSet>>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<MobileStartSet>>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<List<MobileStartSet>>> responseEntity =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(map), parameterizedTypeReference);
            if (responseEntity.getStatusCode().is2xxSuccessful() && responseEntity.getBody().getStatus().equals(HttpStatus.OK.value())) {
                mobileStartSetList = responseEntity.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("/semc/mobile/start/set/selectAppStartSet error{}", e.getMessage());
        }
        return mobileStartSetList;
    }

    @Override
    public MobileNewsAnnouncementPageResp queryMobileNewsListPage(ApiRequsetNews apiRequsetNews) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/news/queryMobileNewsListPage";

        Map<String, Object> uriVariables = new HashMap<>();
        if (ObjectUtils.isEmpty(apiRequsetNews.getSortType())) {
            uriVariables.put("sortType", 1);
        } else {
            uriVariables.put("sortType", apiRequsetNews.getSortType());
        }
        if (!CollectionUtils.isEmpty(apiRequsetNews.getNewsTypeIdList())) {
            uriVariables.put("newsTypeIdList", apiRequsetNews.getNewsTypeIdList());
        }
        uriVariables.put("orderByRule", apiRequsetNews.getOrderByRule());
        // uriVariables.put("newsTypeId", apiRequsetNews.getNewsTypeId());
        uriVariables.put("effectiveTimeStart", apiRequsetNews.getEffectiveTimeStart());
        uriVariables.put("effectiveTimeEnd", apiRequsetNews.getEffectiveTimeEnd());
        uriVariables.put("attachmentFlag", apiRequsetNews.getAttachmentFlag());
        uriVariables.put("pageNum", apiRequsetNews.getPageNum());
        uriVariables.put("pageSize", apiRequsetNews.getPageSize());
        uriVariables.put("keyword", apiRequsetNews.getKeyword());

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<MobileNewsAnnouncementPageResp>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<MobileNewsAnnouncementPageResp>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<MobileNewsAnnouncementPageResp>> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", apiRequsetNews.getLocale(), apiRequsetNews.getIamUserToken(), apiRequsetNews.getTenantId())
                , JsonUtil.javaObjectToJsonString(uriVariables), responseType);

        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return Objects.requireNonNull(responseEntity.getBody()).getResponse();
        }
        return null;
    }

    @Override
    public MobileNewsAnnouncement queryUserNewsDetail(ApiRequsetNews apiRequsetNews) {

        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/news/queryUserNewsDetail";

        Map<String, Object> uriVariables = new HashMap<>();
        uriVariables.put("id", apiRequsetNews.getId());

        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<MobileNewsAnnouncement>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<MobileNewsAnnouncement>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<MobileNewsAnnouncement>> responseEntity =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", apiRequsetNews.getLocale(), apiRequsetNews.getIamUserToken(), apiRequsetNews.getTenantId())
                            , JsonUtil.javaObjectToJsonString(uriVariables), parameterizedTypeReference);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return Objects.requireNonNull(responseEntity.getBody()).getResponse();
            }
        } catch (Exception e) {
            log.error("/news/queryUserNewsDetail error {}", e.getMessage());
        }
        return null;
    }

    @Override
    public JSONObject validateNews(ApiRequsetNews apiRequsetNews) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/news/validateNews";

        Map<String, Object> uriVariables = new HashMap<>();
        uriVariables.put("id", apiRequsetNews.getId());
        uriVariables.put("scene", apiRequsetNews.getScene());

        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<JSONObject>> responseEntity =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", apiRequsetNews.getLocale(),
                            apiRequsetNews.getIamUserToken(), apiRequsetNews.getTenantId()), JsonUtil.javaObjectToJsonString(uriVariables), parameterizedTypeReference);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return Objects.requireNonNull(responseEntity.getBody()).getResponse();
            }
        } catch (Exception e) {
            log.error("/news/validateNews error{}", e.getMessage());
        }
        return null;
    }

    @Override
    public List<MobileNewsType> queryNewsTypeList(ApiRequsetNews apiRequsetNews) {

        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/news/type/queryNewsTypeList";

        Map<String, Object> uriVariables = new HashMap<>();
        //是否查询公告类型当前用户有权限的公告数（true查询，false和空不查询）
        uriVariables.put("queryAuthNewsCount", false);

        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<List<MobileNewsType>>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<MobileNewsType>>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<List<MobileNewsType>>> responseEntity =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", apiRequsetNews.getLocale(), apiRequsetNews.getIamUserToken(), apiRequsetNews.getTenantId())
                            , JsonUtil.javaObjectToJsonString(uriVariables), parameterizedTypeReference);

            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return Objects.requireNonNull(responseEntity.getBody()).getResponse();
            }
        } catch (Exception e) {
            log.error("/news/queryNewsTypeList error {}", e.getMessage());
        }
        return null;
    }

    @Override
    public Boolean readNews(ApiRequsetNews apiRequsetNews) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/news/readNews";

        Map<String, Object> uriVariables = new HashMap<>();
        uriVariables.put("id", apiRequsetNews.getId());

        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<Boolean>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<Boolean>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<Boolean>> responseEntity =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", apiRequsetNews.getLocale(),
                            apiRequsetNews.getIamUserToken(), apiRequsetNews.getTenantId()), JsonUtil.javaObjectToJsonString(uriVariables), parameterizedTypeReference);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return Objects.requireNonNull(responseEntity.getBody()).getResponse();
            }
        } catch (Exception e) {
            log.error("/news/readNews error{}", e.getMessage());
        }
        return null;
    }

    @Override
    public Integer likeNews(ApiRequsetNews apiRequsetNews) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/news/likeNews";

        Map<String, Object> uriVariables = new HashMap<>();
        uriVariables.put("id", apiRequsetNews.getId());

        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<Integer>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<Integer>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<Integer>> responseEntity =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", apiRequsetNews.getLocale(),
                            apiRequsetNews.getIamUserToken(), apiRequsetNews.getTenantId()), JsonUtil.javaObjectToJsonString(uriVariables), parameterizedTypeReference);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return Objects.requireNonNull(responseEntity.getBody()).getResponse();
            }
        } catch (Exception e) {
            log.error("/news/likeNews error{}", e.getMessage());
        }
        return null;
    }

    @Override
    public Integer cancelLikeNews(ApiRequsetNews apiRequsetNews) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/news/cancelLikeNews";

        Map<String, Object> uriVariables = new HashMap<>();
        uriVariables.put("id", apiRequsetNews.getId());

        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<Integer>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<Integer>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<Integer>> responseEntity =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", apiRequsetNews.getLocale(),
                            apiRequsetNews.getIamUserToken(), apiRequsetNews.getTenantId()), JsonUtil.javaObjectToJsonString(uriVariables), parameterizedTypeReference);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return Objects.requireNonNull(responseEntity.getBody()).getResponse();
            }
        } catch (Exception e) {
            log.error("/news/cancelLikeNews error{}", e.getMessage());
        }
        return null;
    }

    @Override
    public Integer favoriteNews(ApiRequsetNews apiRequsetNews) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/news/favoriteNews";

        Map<String, Object> uriVariables = new HashMap<>();
        uriVariables.put("id", apiRequsetNews.getId());

        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<Integer>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<Integer>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<Integer>> responseEntity =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", apiRequsetNews.getLocale(),
                            apiRequsetNews.getIamUserToken(), apiRequsetNews.getTenantId()), JsonUtil.javaObjectToJsonString(uriVariables), parameterizedTypeReference);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return Objects.requireNonNull(responseEntity.getBody()).getResponse();
            }
        } catch (Exception e) {
            log.error("/news/favoriteNews error{}", e.getMessage());
        }
        return null;
    }

    @Override
    public Integer cancelFavoriteNews(ApiRequsetNews apiRequsetNews) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/news/cancelFavoriteNews";

        Map<String, Object> uriVariables = new HashMap<>();
        uriVariables.put("idList", apiRequsetNews.getIdList());

        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<Integer>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<Integer>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<Integer>> responseEntity =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", apiRequsetNews.getLocale(),
                            apiRequsetNews.getIamUserToken(), apiRequsetNews.getTenantId()), JsonUtil.javaObjectToJsonString(uriVariables), parameterizedTypeReference);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return Objects.requireNonNull(responseEntity.getBody()).getResponse();
            }
        } catch (Exception e) {
            log.error("/news/cancelFavoriteNews error{}", e.getMessage());
        }
        return null;
    }

    @Override
    public MyNewsAnnouncementFavoritePageResp myFavoriteNewsList(ApiRequsetNews apiRequsetNews) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/news/myFavoriteNewsList";
        Map<String, Object> uriVariables = new HashMap<>();
        uriVariables.put("pageNum", apiRequsetNews.getPageNum());
        uriVariables.put("pageSize", apiRequsetNews.getPageSize());
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<MyNewsAnnouncementFavoritePageResp>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<MyNewsAnnouncementFavoritePageResp>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<MyNewsAnnouncementFavoritePageResp>> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", apiRequsetNews.getLocale(), apiRequsetNews.getIamUserToken(), apiRequsetNews.getTenantId())
                , JsonUtil.javaObjectToJsonString(uriVariables), responseType);

        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return Objects.requireNonNull(responseEntity.getBody()).getResponse();
        }
        return null;
    }

    /**
     * 校验公告类型是否存在
     *
     * @param apiRequsetNews             请求入参
     * @param athenaBasicHttpRequestHead 请求头
     * @return 返回
     */
    @Override
    public Boolean validNewsType(ApiRequsetNews apiRequsetNews, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead) {
        String path = API_PREFIX + "/news/type/validNewsType";
        String url = AppContext.getApiUrlSetting().getSemcUrl() + path;

        JSONObject params = new JSONObject();
        params.put("newsTypeId", apiRequsetNews.getNewsTypeId());

        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<Boolean>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<Boolean>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<Boolean>> responseEntity =
                    this.httpService.doPost(url, athenaBasicHttpRequestHead, params.toJSONString(), parameterizedTypeReference);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return Objects.requireNonNull(responseEntity.getBody()).getResponse();
            }
        } catch (Exception e) {
            log.error("{} | valid news type error. param:{}", path, apiRequsetNews, e);
        }
        return null;
    }

    @Override
    public MobilePortalCacheConfigParamDTO getMobilePortalCacheConfigParam(AthenaBasicHttpRequestHead athenaBasicHttpRequestHead) {
        String path = API_PREFIX + "/mobile/common/config/getPortalCacheConfigParam";
        String url = AppContext.getApiUrlSetting().getSemcUrl() + path;
        try {
            // 使用ParameterizedTypeReference对返回带泛型参数的包装
            ParameterizedTypeReference<DigiwinAthenaApiResponse<MobilePortalCacheConfigParamDTO>> responseType = new ParameterizedTypeReference<DigiwinAthenaApiResponse<MobilePortalCacheConfigParamDTO>>() {
            };
            ResponseEntity<DigiwinAthenaApiResponse<MobilePortalCacheConfigParamDTO>> responseEntity = httpService.doPost(url, athenaBasicHttpRequestHead, responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful() && responseEntity.getBody() != null) {
                return responseEntity.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("{} error{}", path, e.getMessage());
        }
        return null;
    }

    @Override
    public Object getCommonConfig(String key, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead) {
        String path = API_PREFIX + "/mobile/common/config/getCommonConfig";
        String url = AppContext.getApiUrlSetting().getSemcUrl() + path;
        try {
            JSONObject params = new JSONObject();
            params.put("key", key);
            // 使用ParameterizedTypeReference对返回带泛型参数的包装
            ParameterizedTypeReference<DigiwinAthenaApiResponse<Object>> responseType = new ParameterizedTypeReference<DigiwinAthenaApiResponse<Object>>() {
            };
            ResponseEntity<DigiwinAthenaApiResponse<Object>> responseEntity = httpService.doPost(url, athenaBasicHttpRequestHead, params.toJSONString(), responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful() && responseEntity.getBody() != null) {
                return responseEntity.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("{} error{}", path, e.getMessage());
        }
        return null;
    }

    @Override
    public JSONObject getSsoUrl(String locale, String iamUserToken, Map<String, Object> params) {
        String path = "/tenant/semc/applink/getSsoUrl";
        String url = AppContext.getApiUrlSetting().getSemcUrl() + path;
        try {
            // 使用ParameterizedTypeReference对返回带泛型参数的包装
            ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>> responseType = new ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>>() {
            };
            ResponseEntity<DigiwinAthenaApiResponse<JSONObject>> responseEntity = httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, iamUserToken), JsonUtil.javaObjectToJsonString(params), responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful() && responseEntity.getBody() != null) {
                return responseEntity.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("{} error{}", path, e.getMessage());
        }
        return null;
    }

    /**
     * 校验当前用户是否有自定义应用的权限
     *
     * @param apiRequsetPortal 请求参数
     * @return 返回
     */
    @Override
    public List<ValidMobileAppAuthResp> validUserAppAuth(ApiRequsetPortal apiRequsetPortal) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + DigiwinSemcProxyService.API_PREFIX + "/mobile/portal/validUserAppAuth";
        Map<String, Object> uriVariables = new HashMap<>();
        uriVariables.put("customApplicationIdList", apiRequsetPortal.getCustomApplicationIdList());
        try {
            ParameterizedTypeReference<DigiwinAthenaApiResponse<List<ValidMobileAppAuthResp>>> parameterizedTypeReference =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<ValidMobileAppAuthResp>>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<List<ValidMobileAppAuthResp>>> responseEntity =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", apiRequsetPortal.getLocale(), apiRequsetPortal.getIamUserToken(), apiRequsetPortal.getTenantId())
                            , JsonUtil.javaObjectToJsonString(uriVariables), parameterizedTypeReference);

            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return Objects.requireNonNull(responseEntity.getBody()).getResponse();
            }
        } catch (Exception e) {
            log.error("valid user app auth error.", e);
        }
        return null;
    }

    @Override
    public DeviceBindConfig deviceBindConfig() {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + API_PREFIX
                + "/device/bind/config";
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DeviceBindConfig>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DeviceBindConfig>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<DeviceBindConfig>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead(), responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : null;
    }

    @Override
    public List<DeviceBindResp> deviceBindList(String iamUserToken) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + API_PREFIX
                + "/device/bind/query";
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DeviceBindResp>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DeviceBindResp>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<List<DeviceBindResp>>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead(iamUserToken), responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : null;
    }

    @Override
    public DeviceBindAuth deviceBindAuth(DeviceBindReq deviceBindReq) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + API_PREFIX
                + "/device/bind/authorize";
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DeviceBindAuth>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DeviceBindAuth>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<DeviceBindAuth>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(),
                        JsonUtil.javaObjectToJsonString(deviceBindReq), responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : null;
    }

    @Override
    public Boolean deviceBindAuto(DeviceBindReq deviceBindReq) {
        String url = AppContext.getApiUrlSetting().getSemcUrl() + API_PREFIX
                + "/device/bind/auto";
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Boolean>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Boolean>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<Boolean>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(),
                        JsonUtil.javaObjectToJsonString(deviceBindReq), responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : false;
    }
}
