package com.digiwin.mobile.mobileuibot.proxy.taskengine.service;

import com.digiwin.mobile.mobileuibot.proxy.taskengine.model.DigiwinTaskEngineActivity;

import java.util.List;
import java.util.Map;

/**
 * 任务引擎接口
 *
 * @author zhangjj
 * @date 2022/7/28 14:26
 */
public interface DigiwinTaskEngineProxyService {

    /**
     * taskengine领域
     */
    String TASKENGINE_PREFIX = "/restful/standard/taskengine";

    /**
     * ptm领域
     */
    String PTM_PREFIX = "/restful/standard/ptm";

    /**
     * 查询任务关卡
     *
     * @param locale
     * @param iamUserToken
     * @param workitemId
     * @return
     */
    List<DigiwinTaskEngineActivity> getTaskEngineActivityList(String locale,
                                                              String iamUserToken,
                                                              String workitemId);

    List<DigiwinTaskEngineActivity> getPtmActivityList(String locale,
                                                       String iamUserToken,
                                                       String workitemId);

    Map<String, Object> submitData(String locale, String iamUserToken,
                                   Map<String, Object> params);

    Map<String, Object> manualDispatch(String locale, String iamUserToken,
                                       Map<String, Object> params);

}
