package com.digiwin.mobile.mobileuibot.proxy.taskengine.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.taskengine.model.DigiwinTaskEngineActivity;
import com.digiwin.mobile.mobileuibot.proxy.taskengine.service.DigiwinTaskEngineProxyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author zhangjj
 * @date 2022/7/28 14:27
 */
@Component
public class DigiwinTaskEngineProxyServiceImpl implements DigiwinTaskEngineProxyService {

    @Autowired
    private HttpService httpService;

    @Override
    public List<DigiwinTaskEngineActivity> getTaskEngineActivityList(String locale, String iamUserToken, String workitemId) {
        String url = AppContext.getApiUrlSetting().getTaskEngineUrl() + TASKENGINE_PREFIX
                + "/api/task/approve/work/previous-activities";

        Map<String, Object> requestData = new HashMap<>();
        requestData.put("locale", locale);
        requestData.put("workitemId", workitemId);

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map>>
                responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Map>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, iamUserToken),
                        JsonUtil.javaObjectToJsonString(requestData), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                JSONArray.parseArray(JsonUtil.javaObjectToJsonString(responseEntity.getBody().getResponse().get("activities")), DigiwinTaskEngineActivity.class) : Collections.emptyList();
    }

    @Override
    public List<DigiwinTaskEngineActivity> getPtmActivityList(String locale, String iamUserToken, String workitemId) {
        String url = AppContext.getApiUrlSetting().getPtmUrl() + PTM_PREFIX
                + "/api/task/approve/work/previous-activities";

        Map<String, Object> requestData = new HashMap<>();
        requestData.put("locale", locale);
        requestData.put("workitemId", workitemId);

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map>>
                responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Map>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, iamUserToken),
                        JsonUtil.javaObjectToJsonString(requestData), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                JSONArray.parseArray(JsonUtil.javaObjectToJsonString(responseEntity.getBody().getResponse().get("activities")), DigiwinTaskEngineActivity.class) : Collections.emptyList();
    }

    @Override
    public Map<String, Object> submitData(String locale, String iamUserToken, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getTaskEngineUrl() + TASKENGINE_PREFIX
                + "/api/task/wait/submit-data";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map>>
                responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Map>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, iamUserToken),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ? responseEntity.getBody().getResponse() : Collections.emptyMap();
    }

    @Override
    public Map<String, Object> manualDispatch(String locale, String iamUserToken, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getTaskEngineUrl() + TASKENGINE_PREFIX
                + "/api/task/manual/dispatch";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map>>
                responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Map>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, iamUserToken),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ? responseEntity.getBody().getResponse() : Collections.emptyMap();
    }
}
