package com.digiwin.mobile.mobileuibot.proxy.tdd.service.impl;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.tdd.service.TddService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @author yanfeng
 * @date 2024/8/5
 */
@Slf4j
@Service("tddServiceImpl")
public class TddServiceImpl implements TddService {

    @Autowired
    private HttpService httpService;

    @Override
    public Boolean checkIsItUser(ApiRequest request) {
        String url = AppContext.getApiUrlSetting().getTddUrl() + "/config/smartUser/check";
        HashMap<Object, Object> params = new HashMap<>();
        params.put("tenantId", request.getTenantId());
        params.put("userId", request.getUserId());

        try {
            ResponseEntity<Map> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", request.getLocale()
                    , request.getIamUserToken(), request.getTenantId()), JsonUtil.javaObjectToJsonString(params), Map.class);
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                log.error("checkIsItUser接口调用失败, url:{} \n request:{} \n responseEntity:{}", url, JsonUtil.javaObjectToJsonString(request), JsonUtil.javaObjectToJsonString(responseEntity));
                return false;
            }
            if (null != responseEntity.getBody()) {
                return (Boolean) responseEntity.getBody().get("data");
            }
        } catch (Exception e) {
            log.error("checkIsItUser接口调用失败, url:{} \n request:{} \n error:{}", url, JsonUtil.javaObjectToJsonString(request), e.getMessage());
            return false;
        }
        return false;
    }

}