package com.digiwin.mobile.mobileuibot.proxy.uibot;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;

/**
 * <p>功能描述：PC端UI Bot数据的layout.group属性反序列化处理器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotLayoutJsonDeserializer
 * @Author: Zaregoto
 * @Date: 2022/5/31 1:12
 */
@Slf4j
public class PcUiBotLayoutJsonDeserializer extends JsonDeserializer<UiBotLayout> {

    @Override
    public UiBotLayout deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        log.debug("PcUiBotLayoutJsonDeserializer activated!!!");
        JsonNode node = jsonParser.getCodec().readTree(jsonParser);
        JsonNode groupNode = node.get("group");
        if (null == groupNode) {
            return JsonUtil.jsonStringToObject(node.toString(), UiBotLayout.class);
        } else {
            if (groupNode instanceof ObjectNode) {
                // 因出现过layout.group属性既是对象，又是数组，故在这里读取原始json数据后，统一处理为数组
                ArrayNode arrayNode = (ArrayNode) jsonParser.getCodec().createArrayNode();
                arrayNode.add(groupNode);
                ((ObjectNode) node).replace("group", arrayNode);
                return JsonUtil.jsonStringToObject(node.toString(), UiBotLayout.class);
            } else if (groupNode instanceof ArrayNode) {
                return JsonUtil.jsonStringToObject(node.toString(), UiBotLayout.class);
            } else {
                return null;
            }
        }
    }
}
