package com.digiwin.mobile.mobileuibot.proxy.uibot;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：PC端UiBot数据中，pageData相关数据处理的工具类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotPageDataUtil
 * @Author: Zaregoto
 * @Date: 2021/11/25 19:59
 */
public class PcUiBotPageDataUtil {

    public static String getBizDataKey(UiBotModel pcUibotModel, String bizDataSchema, Map<String, Object> bizData) {
        /**
         * 		"pageDataKeys": {
         * 			"purchase_temp": ["purchase_seq", "purchase_sub_seq", "purchase_no"]
         *        },
         */
        String key = "";
        if (null != pcUibotModel.getPageDataKeys()) {
            Map<String, Object> pageDataKeys = pcUibotModel.getPageDataKeys();
            if (pageDataKeys.containsKey(bizDataSchema)) {
                List<String> bizDataKeyList = (List<String>) pageDataKeys.get(bizDataSchema);
                List<String> bizDataValueList = new ArrayList<>(bizDataKeyList.size());
                for (String bizDataKey : bizDataKeyList) {
                    bizDataValueList.add(String.valueOf(bizData.get(bizDataKey)));
                }
                /**
                 * 因为PC端定义业务key值若只有一个字段，最后还是会多一个分号。
                 * 所以为了在移动端展示条目的详情时匹配得上，故意加上一个空字符串
                 */
                if (bizDataValueList.size() == 1) {
                    bizDataValueList.add("");
                }
                key = String.join(";", bizDataValueList);
            }
        } else {
            key = String.valueOf(bizData.get("__DATA_KEY"));
        }

        return key;
    }
}
