package com.digiwin.mobile.mobileuibot.proxy.uibot.model;


import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：鼎捷雅典娜PC UI Bot行动定义</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotAction
 * @Author: zaregoto
 * @Date: 2023/2/27 16:30
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class PcUiBotAction implements Serializable {

    private static final long serialVersionUID = -425619024598784302L;

    /**
     * 移动设计器submitAction唯一标识，关联使用 -- 移动设计器新增属性
     */
    private String uuid;
    /**
     * 移动设计器submitAction的btnId，相当于schema，提供给前端，作用于规则校验 -- 移动设计器新增属性
     */
    private String btnId;
    /**
     * 移动设计器动作类型,跳转页面/提交 -- 移动设计器新增属性
     *
     * @see com.digiwin.mobile.mobileuibot.core.component.button.ButtonTypeEnum
     */
    private String btnType;
    /**
     * 移动设计器跳转类型，相关配置属性 -- 移动设计器新增属性
     */
    private UiBotJumpAction jumpAction;

    /**
     * action的显示标题
     */
    private String title;

    /**
     * action的id,themeMap中定义
     */
    private String actionId;

    /**
     * 按钮类型标示
     */
    private String actionType;

    /**
     * 同步异步
     */
    private String invokeType;

    /**
     * action的类型，目前只有ESP(业务)和WF(工作流BPM)
     */
    private String category;

    /**
     * 服务Id，包括服务真正执行的服务
     */
    private PcUiBotActionServiceId serviceId;

    /**
     * 执行Action的参数,是多个的合并，执行的时候是分开执行
     */
    private Map<String, Object> paras;

    /**
     * 营运单元
     */
    private Map<String, Object> businessUnit;

    /**
     * 所有转换参数的定义
     */
    private List<PcUiBotActionParameterMapping> actionParams;

    /**
     * 给前端使用的扩展字段
     */
    private Map<String, Object> extendedFields;

    /**
     * 开窗or提交时追加营运单元信息
     */
    private List<Map> appendRowBusinessUnitSelect;

    /**
     * 用于用户行为轨迹上报的，轨迹代号
     */
    private String trackCode;

    /**
     * 是否是客制 ture：是客制；false：非客制（默认不填为非客制）
     */
    private Boolean isCustomize;

    private String type;

    private String schema;

    /**
     * 配置数据源查询入参
     */
    private List<PcUiBotActionSearchInfoMapping> searchInfos;
}
