package com.digiwin.mobile.mobileuibot.proxy.uibot.model;


import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：鼎捷雅典娜PC UI Bot信息搜索映射定义</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotActionSearchInfoMapping
 * @Author: zaregoto
 * @Date: 2023/2/27 16:30
 */
@Data
public class PcUiBotActionSearchInfoMapping implements Serializable {

    private static final long serialVersionUID = -8029119457605541866L;
    /**
     * 搜索字段名，对应schema
     */
    private String searchField;
    /**
     * 数据类型
     * 当枚举时(SELECT)
     * options必配
     */
    private String dataType;

    /**
     * select 编辑器的选项列表
     * title:  显示值
     * value:  实际值
     */
    private List<Map<String, Object>> options;

    /**
     * 数据值
     */
    private Object searchValue;
    /**
     * constant为固定变量
     */
    private String paramType;

    /**
     * like  等等
     */
    private String searchOperator;

    /**
     * 条件的排序信息
     */
    private Integer order;

    /**
     * 英文左右括号符号"(",")"
     */
    private String bracket;

    /**
     * 逻辑信息 and 或者or ，其他暂不支持
     */
    private String logic;

    /**
     * 与前一条件的逻辑关系，and 或者 or
     */
    private String preLogic;


}
