package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import cn.hutool.core.map.MapUtil;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：鼎捷雅典娜任务相关常量</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotActivityConstants
 * @Author: zaregoto
 * @Date: 2023/2/27 16:30
 */
public class PcUiBotActivityConstants {
    public static final String PARENT_COMPONENT_TYPE_FORM = "FORM";

    /**
     * 执行者
     */
    public static final String PERFORMER = "performer";

    /**
     * 当责者
     */
    public static final String CHARGE = "charge";

    /**
     * 业务数据bpmData中的当责者
     */
    public static final String PERSON_IN_CHARGE = "personInCharge";

    /**
     * 项目卡
     */
    public static final String PROJECT_CARD = "project-card";
    /**
     * 任务卡
     */
    public static final String TASK_CARD = "task-card";
    /**
     * 项目卡详情
     */
    public static final String PROJECT_DETAIL = "project-detail";
    /**
     * 活动卡详情
     */
    public static final String TASK_DETAIL = "task-detail";

    public static final String HISTORY = "history";

    public static final String CONDITION_DETAIL = "condition-detail";

    /**
     * 基础资料录入 -- 单档，页面
     */
    public static final String BASIC_DATA = "basic-data";

    /**
     * 基础资料录入-双档，浏览页面
     */
    public static final String BROWSE_PAGE = "browse-page";

    /**
     * 基础资料录入-双档，EDIT页面
     */
    public static final String EDIT_PAGE = "edit-page";

    /**
     * 基础资料类型
     */
    public static final String PATTERN_BASIC_DATA = "DATA_ENTRY";
    // 移动工作台类型
    public static final String PATTERN_WORKBENCH = "MobilePageDesign";

    public static final String CATEGORY_SINGLE_DOC = "SINGLE-DOCUMENT";
    // 模型驱动，单档
    public static final String CATEGORY_SING_DOC = "SIGN-DOCUMENT";

    public static final String CATEGORY_RECYCLE = "RECYCLE";
    // 模型驱动，双档
    // wjw FIXME: 2023/12/6 运行态 单档(模型驱动) / 双档(模型驱动) / 多档(模型驱动) category都是DOUBLE-DOCUMENT
    public static final String CATEGORY_DOUBLE_DOC = "DOUBLE-DOCUMENT";
    public static final String CATEGORY_TREEDATA_DOUBLE_DOC = "TREEDATA-DOUBLE-DOCUMENT";
    public static final String CATEGORY_TREEDATA_SINGLE_DOC = "TREEDATA-SINGLE-DOCUMENT";
    // lcdp双档
    public static final String CATEGORY_DESIGNER_DOC = "DESIGNER-DOCUMENT";
    // lcdp单档
    public static final String CATEGORY_DESIGNER_SIGN_DOCUMENT_DOC = "DESIGNER-SIGN-DOCUMENT";
    public static final List<String> CATEGORYS = Arrays.asList("DOUBLE-DOCUMENT", "TREEDATA-DOUBLE-DOCUMENT", "DESIGNER-DOCUMENT", "DOUBLE-DOCUMENT-MULTI", "DOUBLE-DOCUMENT-FORM", "TREEDATA-DOUBLE-DOCUMENT-MULTI", "TREEDATA-DOUBLE-DOCUMENT-FORM");

    /**
     * 报表pattern
     */
    public static final String PATTERN_STATEMENT = "STATEMENT";

    /**
     * PATTERN-业务型
     */
    public static final String PATTERN_BUSINESS = "BUSINESS";

    /**
     * 模型驱动生成的任务
     */
    public static final String CATEGORY_DATA_ENTRY_DRIVEN = "DATA_ENTRY_DRIVEN";

    /**
     * PATTERN-机制型
     */
    public static final String PATTERN_MECHANISM = "MECHANISM";

    /**
     * PATTERN-调整型
     */
    public static final String PATTERN_ADJUSTMENT = "ADJUSTMENT";

    /**
     * 自定义类型
     */
    public static final String PATTERN_CUSTOM = "CUSTOM";

    /**
     * 基础资料类型
     */
    public static final String PATTERN_DATA_ENTRY = "DATA_ENTRY";

    /**
     * 回复类别
     */
    public static final String CATEGORY_REPLY = "REPLY";

    /**
     * 检查类别
     */
    public static final String CATEGORY_CHECK = "CHECK";

    /**
     * 签核类别
     */
    public static final String CATEGORY_APPROVAL = "APPROVAL";

    /**
     * 机制类别
     */
    public static final String CATEGORY_ADJUSTMENT = "ADJUSTMENT";

    /**
     * 解决类别
     */
    public static final String CATEGORY_SOLVE = "SOLVE";


    /**
     * 变更
     */
    public static final String CATEGORY_MODIFY = "MODIFY";


    /**
     * 回报类别
     */
    public static final String CATEGORY_REPORT = "REPORT";


    /**
     * 库存异动
     */
    public static final String CATEGORY_STOCK_CHANGE = "StockChange";


    /**
     * 处理
     */
    public static final String CATEGORY_PROCESS = "PROCESS";

    /**
     * 消息
     */
    public static final String CATEGORY_MESSAGE = "MESSAGE";

    /**
     * 追踪
     */
    public static final String CATEGORY_TRACE = "TRACE";

    /**
     * 建议
     */
    public static final String CATEGORY_SUGGESTION = "SUGGESTION";


    /**
     * 活动名称--签核
     */
    public static final String ACTIVITY_PURCHASE_APPROVAL = "purchaseApproval";


    /**
     * 活动名称--机制型签核
     */
    public static final String ACTIVITY_SUPPLIER_MECHANISM_APPROVAL = "supplierMechanismApproval";

    /**
     * 活动名称 --机制型调整
     */
    public static final String ACTIVITY_SUPPLIER_MECHANISM_SUGGESTION = "supplierMechanismSuggestion";

    public static final String PATTERN_DIALOG = "DIALOG";

    public static class ActionParamType {
        public static final String ACTIVE_PARENT_ROW = "ACTIVE_PARENT_ROW";

        public static final String ACTIVE_ROW_CONSTANT = "ACTIVE_ROW_CONSTANT";
    }

    /**
     * 报表全客制
     */
    public static final String CUSTOM_STATEMENT = "CUSTOM-STATEMENT";

    /**
     * 方向：竖向
     */
    public static final String DIRECTION_COLUMN = "COLUMN";

    /**
     * 任务撤回、数据终止 数据源类型
     */
    public static final String SHELVED_DATA_SOURCE_TYPE = "SHELVED_DATA";

    /**
     * 双档基础资料和前端特殊约定 返回的数据必须加上edit_type = 1
     */
    public static final String EDIT_TYPE = "edit_type";

    /**
     * 预期任务code
     */
    public static final String UIBOT_OVERDUE_TASK = "uibot_overdue_task";

    public static final Map<String, Object> EDIT_TYPE_MAP = MapUtil.of(EDIT_TYPE, 1);

    /**
     * 动作类型
     */
    public static class TmActionType {

        public static final String ESP = "ESP";

        public static final String BPM = "BPM";

        public static final String COMBINE = "COMBINE";

    }

    /**
     * 动作类型
     */
    public static class Category {

        public static final String START_PROJECT = "StartProject";

    }

    /**
     * 基础资料动作类型
     */
    public static class BasicDataActionType {

        public static final String BASIC_DATA_COMBINE_SAVE = "basic-data-combine-save";

        public static final String BASIC_DATA_UPDATE = "basic-data-update";

        public static final String BASIC_DATA_SAVE = "basic-data-save";

        public static final String BASIC_DATA_DELETE = "basic-data-delete";
    }
}
