package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import lombok.Data;

import java.util.HashMap;

@Data
public class PcUiBotAllFields {

    /**
     * 字段的schema
     */
    private String name;

    /**
     * 当前字段的全路径
     */
    private String path;
    /**
     * 当前字段显示的名称
     */
    private String headerName;

    /**
     * 当前字段所在的相对层级
     */
    private Integer level;

    /**
     * 当前字段默认值
     */
    private Object defaultValue;

    /**
     * 当前字段类型
     */
    private String dataType;
    /**
     * 是否支持排序
     */
    private Boolean sort;
    /**
     * 是否为主键
     */
    private Boolean isDataKey;
    /**
     * 是否显示
     */
    private Boolean isShow;


    public PcUiBotAllFields createValue(PcUiBotAllFields allfields, PcUiBotMetadataField field) {
        if (field.getDataType() == null) {
            return allfields;
        }
        allfields.setName(field.getName());
        allfields.setPath(field.getPath());
        allfields.setHeaderName(field.getDescription());
        allfields.setDataType(field.getDataType());
        if (field.isArray()) {
            allfields.setDataType("array");
            allfields.setDefaultValue(new Object[0]);
        } else if (field.getDataType().equals(PcUiBotApiMetadataConstants.METADATA_OBJECT)) {
            allfields.setDefaultValue(new HashMap<>());
        } else {// 如果是基本数据类型及其包装类型 + String
            allfields.setDefaultValue(getPrimitiveTypeDefaultValue(field));
        }
        allfields.setSort(field.getCanSort());
        return allfields;
    }

    // 年月日
    public static final String DATA_TYPE_DATE = "date";
    // 年月日时分秒
    public static final String DATA_TYPE_DATETIME = "datetime";
    // 时分秒
    public static final String DATA_TYPE_TIME = "time";

    public static final String DATA_TYPE_STRING = "string";

    public static final String DATA_TYPE_NUMBER = "number";

    public static final String DATA_TYPE_NUMERIC = "numeric";

    public static final String DATA_TYPE_BOOLEAN = "boolean";

    /**
     * 生成基本数据类型的默认值：
     * 数组：返回: []
     * 数字：返回：null
     * 布尔：返回：null
     * 日期、字符串，返回：""
     *
     * @param metadataField
     * @return
     */
    private static Object getPrimitiveTypeDefaultValue(PcUiBotMetadataField metadataField) {
        if (metadataField.isArray()) {
            return new String[]{};
        }

        if (DATA_TYPE_NUMBER.equals(metadataField.getDataType()) || DATA_TYPE_NUMERIC.equals(metadataField.getDataType())) {
            return null;
        } else if (DATA_TYPE_BOOLEAN.equals(metadataField.getDataType())) {
            return null;
        } else {
            return "";
        }
    }

    /**
     * 是否必填
     */
    private Boolean isRequired;


}
