package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.*;

/**
 * <p>功能描述：元数据 结构信息</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotApiMetadata.java
 * @Author: wangjwc
 * @Date: created at 2023/7/3 17:32
 */
@Data
public class PcUiBotApiMetadata implements Serializable {


    /**
     * 元数据ID
     */
    private String actionId;

    /**
     * 元数据名称
     */
    private String serviceName;

    /**
     * request 字段集合
     */
    private List<PcUiBotMetadataField> requestFields;


    /**
     * 把子节点变成带路径的结构
     */
    private Map<String, PcUiBotMetadataField> requestFieldMap = new HashMap<>();


    /**
     * response 字段集合
     */
    private List<PcUiBotMetadataField> responseFields;


    /**
     * 把子节点变成带路径的结构
     */
    private Map<String, PcUiBotMetadataField> responseFieldMap = new HashMap<>();


    public void addResponseFields(List<PcUiBotMetadataField> fields) {
        if (this.responseFields == null) {
            this.responseFields = new ArrayList<>();
        }
        if (CollectionUtils.isEmpty(fields)) {
            return;
        }
        if (this.responseFields.isEmpty()) {
            this.responseFields.addAll(fields);
        } else {
            if (this.responseFields.get(0).getSubFields() == null) {
                this.responseFields.get(0).setSubFields(new ArrayList<>());
            }
            Set<String> allFields = new HashSet<>();
            for (PcUiBotMetadataField subField : this.responseFields.get(0).getSubFields()) {
                allFields.add(subField.getName());
            }
            for (PcUiBotMetadataField field : fields) {
                if (!allFields.contains(field.getName())) {
                    this.responseFields.get(0).getSubFields().add(field);
                } else {
                    //已经存在的，替换掉，因为指定元数据目的应该有2个：增加缺少的和替换
                    Optional<PcUiBotMetadataField> existFieldOptional = this.responseFields.get(0).getSubFields().stream().filter(x -> Objects.equals(x.getName(), field.getName())).findFirst();
                    if (existFieldOptional.isPresent()) {
                        PcUiBotMetadataField existFiled = existFieldOptional.get();
                        this.responseFields.get(0).getSubFields().remove(existFiled);
                        this.responseFields.get(0).getSubFields().add(field);
                    }

                }
            }
        }
    }
}
