package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.extern.slf4j.Slf4j;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

/**
 * <p>功能描述：鼎捷雅典娜PC UI Bot相关常量</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotConstants
 * @Author: zaregoto
 * @Date: 2023/2/27 16:30
 */
public final class PcUiBotConstants {

    public static final List<String> ACTION_LIST = Arrays.asList("dispatch", "reexecute", "agree", "disagree", "reassign", "reapprove", "add-task", "terminate-task");

    public static final String cacheKeyPrefix = "uibot:cache:";

    /**
     * ESP服务类别
     */
    public static final String DATA_SOURCE_DATA_KEY = "__DATA_KEY";

    /**
     * 前端透传入参
     */
    public static final String UIBOT_PAGE_PARAMETER = "uibot__page__parameter";

    /**
     * ESP服务类别
     */
    public static final String ACTION_CATEGORY_ESP = "ESP";

    /**
     * ESP服务类别
     */
    public static final String ACTION_CATEGORY_RECYCLE = "RECYCLE";

    /**
     * ATMC
     */
    public static final String ACTION_CATEGORY_UIBOT = "UIBOT";

    public static final String ACTION_CATEGORY_RAW_DATA = "RAWDATA";

    /**
     * 低代码设计器数据中心
     */
    public static final String ACTION_CATEGORY_LCDP = "LCDP";

    /**
     * BPM服务关键字
     */
    public static final String ACTION_CATEGORY_BPM = "WF";

    /**
     * BPM-任务引擎 服务关键字
     */
    public static final String ACTION_CATEGORY_BPM_TASK_ENGINE = "TaskEngine";

    /**
     * 决策模型流程 服务关键字
     */
    public static final String ACTION_CATEGORY_WORKFLOW = "workflow";

    /**
     * BPM-PTM 服务关键字
     */
    public static final String ACTION_CATEGORY_BPM_PTM = "PTM";

    /**
     * PTM_DATA 服务关键字
     */
    public static final String ACTION_CATEGORY_PTM_DATA = "PTM_DATA";

    /**
     * BPM服务关键字
     */
    public static final String ACTION_CATEGORY_SD = "SD";

    /**
     * 混合的数据源
     */
    public static final String ACTION_CATEGORY_MIX_JOIN = "MIX_JOIN";

    /**
     * 混合的数据源-left join
     */
    public static final String ACTION_CATEGORY_MIX_LEFT_JOIN = "MIX_LEFT_JOIN";

    /**
     * 混合的数据源
     */
    public static final String ACTION_CATEGORY_MIX_MERGE = "MIX_MERGE";
    /**
     * 混合的数据源，
     */
    public static final String ACTION_CATEGORY_MIX_UNION = "MIX_UNION";
    /**
     * 混合的数据源
     */
    public static final String ACTION_CATEGORY_RELATION_QUERY = "MIX_RELATION_QUERY";

    /**
     * EPS服务KEY的加密算法
     */
    public static final String ESP_KEY_ALGORITHM = "MD5";
    /**
     * ESP服务KEY的加密字符串编码
     */
    public static final String ESP_KEY_CHARSET_UTF8 = "utf-8";

    /**
     * ThemeMap服务关键字
     */
    public static final String ACTION_CATEGORY_TM = "TM";

    /**
     * ATMC变更任务数据源
     */
    public static final String ACTION_CATEGORY_ATMC_CHANGE = "ATMC_CHANGE";

    /**
     * ATMC逾期任务卡数据源
     */
    public static final String ACTION_CATEGORY_ATMC = "ATMC";

    /**
     * 客户端来源标识--移动端
     */
    public static final String MOBILE_PLATFORM = "mobileplatform";

    /**
     * web端
     */
    public static final String WEB_PLATFORM = "webplatform";

    /**
     * DataSourceProcess执行的时机点，全部action执行完成后
     */
    public static final String DATA_PROCESS_ACTIVE_POINT_EXECUTE_COMPLETED = "executeCompleted";

    /**
     *
     */
    public static final String UIBOT_FIELDS_CHECKED = "uibot_checked";

    /**
     *
     */
    public static final String UIBOT_FIELDS_ID = "uibot_id";

    /**
     * 回复型任务注册邀请
     */
    public static final String UIBOT_REPLY_INVITE = "uibot__reply_invite";

    /**
     * activityData的key
     */
    public static final String UIBOT_FIELDS_ACTIVITY = "uiBot__activity";

    /**
     * 回复型任务数据头
     */
    public static final String REPLY_DATE_HEAD = "reply_date_HEAD";


    /**
     * activityBackLogDataData的key
     */
    public static final String UIBOT_FIELDS_ACTIVITY_BACKLOG = "activity__backLog__data";

    public static final String DEFAULT_BUTTON_TRACK_CODE = "SUBMIT";
    /**
     * 任务撤回相关的的key
     */
    public static final String UIBOT_RETRIEVE = "uibot_retrive";

    /**
     * 新撤回按钮actionId
     */
    public static final String UIBOT_TASK_WITHDRAW = "uibot_task_withdraw";

    /**
     * 支持跨BK撤回按钮actionId
     */
    public static final String UIBOT_TASK_WITHDRAW_CROSS_BK = "uibot_task_withdraw_cross_bk";

    public static final String RETRIEVE = "retrieve";
    public static final String TaskReturn = "task-return";

    public static final Integer DATA_UNIFORMITY_TYPE = 89;

    public static final String NAVIGATE_TARGET_ALL = "all";

    /**
     * 组件的父组件类型
     */
    public static final String PARENT_COMPONENT_TYPE_TABLE = "TABLE";

    /**
     * 元数据组标签类型
     */
    public static final String TAG_GROUP_TYPE = "NAME_CODE";

    /**
     * 根据operation的operate判断是否为开窗操作
     */
    public static final List<String> OPEN_WINDOW_OPERATE_LIST = Arrays.asList("openwindow", "openChart", "open-task-window");

    /**
     * 取SD中的bpmdata流程的元数据配置api字段
     * https://hx3wbv0mcjh.feishu.cn/wiki/ZvixwGJxtiWMhGk3ipscJGbXnJh
     */
    public static final String UIBOT_ACTION_METADATA = "UIBOT_ACTION_METADATA";

    /**
     * 取SD中的bpmdata流程的隐藏的字段
     * 用于存放需要隐藏的字段name,如："UIBOT_HIDDEN_FIELDS":["BK1","BK2"]
     * https://hx3wbv0mcjh.feishu.cn/wiki/ZvixwGJxtiWMhGk3ipscJGbXnJh
     */
    public static final String UIBOT_HIDDEN_FIELDS = "UIBOT_HIDDEN_FIELDS";

    /**
     * 内含外显字段匹配类型
     */
    public enum MatchType {
        // 前缀
        PREFIX,
        // 后缀
        SUFFIX
    }

    /**
     * 符号
     */
    public static class Symbol {

        private Symbol() {
        }

        public static final String DOUBLE_UNDERLINE = "__";

    }

    public static class ApiFieldType {

        private ApiFieldType() {
        }

        /**
         * 关键字
         */
        public static final String DATA_KEY = "datakey";

        /**
         * 自定义header
         */
        public static final String HEADER = "H";

        /**
         * 自定义header字段
         */
        public static final String HEADER_FIELD = "HF";

        /**
         * 简单参数
         */
        public static final String SIMPLE_PARAM = "P";

        /**
         * 单头
         */
        public static final String SINGLE_HEAD = "M";

        /**
         * 单头字段
         */
        public static final String SINGLE_HEAD_FIELD = "MF";

        /**
         * 单身
         */
        public static final String SINGLE_BODY = "D";

        /**
         * 单身栏位
         */
        public static final String SINGLE_BODY_FIELD = "DF";

        /**
         * 子单身
         */
        public static final String CHILD_SINGLE_BODY = "SD";

        /**
         * 子单身字段
         */
        public static final String CHILD_SINGLE_BODY_FIELD = "SDF";

    }

    /**
     * 规则类型
     */
    public static class RuleConfigKey {
        private RuleConfigKey() {
        }

        /**
         * 规则类型
         */
        public static final String KEY = "key";

        /**
         * 规则是否生效
         */
        public static final String EFFECTIVE = "effective";

        /**
         * 规则作用字段
         */
        public static final String SCHEMA = "schema";

        /**
         * 作用字段
         */
        public static final String TARGET_SCHEMA = "targetSchema";

        /**
         * 关联字段
         */
        public static final String LINKAGE_SCHEMAS = "linkageSchemas";
    }

    /**
     * 规则类型
     */
    public static class RuleKeyType {

        private RuleKeyType() {
        }

        public static final String REQUIRED = "required";

        public static final String CUSTOM = "custom";

        public static final String COLOR = "color";

        public static final String DEFAULT_VALUE = "defaultValue";

        public static final String DISABLED = "disabled";

        public static final String HIDDEN = "hidden";

        /**
         * 欧博士提示机制辅导信息
         */
        public static final String API_TRIGGER = "api-trigger";
    }

    /**
     * 触发时机
     */
    public static class TriggerPoint {

        private TriggerPoint() {
        }

        /**
         * 默认-规则
         */
        public static final String DEFAULT = "default";

        /**
         * 初始化-操作
         */
        public static final String INIT = "init";

        /**
         * 提交时-规则
         */
        public static final String IN_SUBMIT = "inSubmit";

        /**
         * 数据变更时-操作
         */
        public static final String DATA_CHANGED = "dataChanged";

    }

    /**
     * 标签分类
     */
    public static class TagCategory {

        private TagCategory() {
        }

        public static final String ORDER = "ORDER";

    }

    /**
     * 词库偏差度统计类型
     */
    public static class WordDeviationDegreeType {

        private WordDeviationDegreeType() {
        }

        public static final String DIMENSION_CATEGORY = "DIMENSION_CATEGORY";
        public static final String TASK = "TASK";
        public static final String API = "API";
    }

    /**
     * 布局方式
     */
    public static class DirectionType {

        private DirectionType() {
        }

        /**
         * 横向
         */
        public static final String DIRECTION_ROW = "ROW";

        /**
         * 竖向
         */
        public static final String DIRECTION_COLUMN = "COLUMN";

    }

    public static class DataType {

        private DataType() {
        }

        public static final String OBJECT = "object";

        public static final String STRING = "string";

        public static final String ARRAY = "array";

        public static final String DATE = "date";

        public static final String DATETIME = "datetime";

        public static final String TIME = "time";

        public static final String NUMBER = "number";

        public static final String NUMERIC = "numeric";

        public static final String BOOLEAN = "boolean";

    }

    public static class ComponentType {

        private ComponentType() {
        }

        public static final String GROUP_INLINE = "GROUP_INLINE";

        public static final String FORM_LIST = "FORM_LIST";

        public static final String TABS = "TABS";

        public static final String DRAWER_BUTTON = "DRAWER_BUTTON";

        public static final String TOOLBAR = "TOOLBAR";

        public static final String TABLE = "TABLE";

        public static final String ATHENA_TABLE = "ATHENA_TABLE";

        public static final String ACTIVITY_TITLE = "ACTIVITY_TITLE";

        public static final String TREE_DATA = "TREEDATA";

        public static final String LAYOUT = "LAYOUT";

        public static final String WORKFLOW_PROGRESS = "WORKFLOW_PROGRESS";

        public static final String CONTENT_QUERY_BUTTON = "CONTENT_QUERY_BUTTON";

        public static final String SIGN_OFF_PROGRESS_LINK = "SIGN_OFF_PROGRESS_LINK";

        public static final String DELIVERY_REPLY_TITLE = "DELIVERY_REPLY_TITLE";

        public static final String DELIVERY_REPLY_DESCRIPTION = "DELIVERY_REPLY_DESCRIPTION";

        public static final String APPROVAL_DESCRIPTION = "APPROVAL_DESCRIPTION";

        public static final String DATA_UNIFORMITY_HISTORY = "DATA_UNIFORMITY_HISTORY";

        public static final String OPERATION_ACTION_PRINT = "ATMC_PRINT";
    }

    /**
     * 操作模式
     */
    public static class TmOperationMode {

        private TmOperationMode() {
        }

        public static final String ROW = "row";

        public static final String ALL = "all";

        public static final String LINE = "line";

    }

    public static class TmOperationOperate {

        private TmOperationOperate() {
        }

        public static final String ADD_ROW = "add-row";

        public static final String OPEN_PAGE = "openpage";
    }

    /**
     * 操作类型
     */
    public static class TmOperationType {

        private TmOperationType() {
        }

        public static final String NAVIGATE_CLIENT = "NAVIGATE_CLIENT";

        /**
         * 抽屉
         */
        public static final String DRAWER = "DRAWER";

        /**
         * 打开子页面
         */
        public static final String OPEN_PAGE = "openpage";

        /**
         * 新增
         */
        public static final String ADD = "add";

        /**
         * 复制
         */
        public static final String COPY = "copy";

        /**
         * 编辑
         */
        public static final String EDIT = "edit";

        /**
         * 上一笔
         */
        public static final String PREVIOUS = "previous";

        /**
         * 下一笔
         */
        public static final String NEXT = "next";

        /**
         * 全定制
         */
        public static final String CUSTOM = "CUSTOMTYPE";

    }

    public static class DataSourceName {

        private DataSourceName() {
        }

        /**
         * 【全局参数】数据源名称
         */
        public static final String UIBOT_GLOBAL_PARAMETER = "uibot__global_parameter";

    }

    public static class FilterMode {

        private FilterMode() {
        }

        /**
         * 前端过滤
         */
        public static final String VALUE = "value";

        /**
         * 后端过滤
         */
        public static final String CONDITION = "condition";

    }

    public static class GridToolbar {

        private GridToolbar() {
        }

        public static final String HIDE_DEFAULT_TOOLBAR = "hideDefaultToolbar";

        public static final String COMPOSITE_SORT_BUTTON = "composite-sort";

        public static final String SETTING_BUTTON = "setting";

        public static final String ADVANCED_SEARCH_BUTTON = "advanced-search";

    }

    public static class BaseDataEditType {

        private BaseDataEditType() {
        }

        public static final String ADD = "add";

        public static final String EDIT = "edit";

    }

    /**
     * 复制操作的复制模式枚举类
     */
    @Slf4j
    public enum OperationCopyMode {
        // 排除字段
        exclude,
        // 字段值+1
        addOne;

        @JsonCreator
        public static OperationCopyMode forValue(String name) {
            OperationCopyMode[] values = OperationCopyMode.values();
            Optional<OperationCopyMode> first = Stream.of(values).filter(mode -> mode.name().equals(name)).findFirst();
            if (first.isPresent()) {
                return first.get();
            }
            log.warn("Enumeration value not supported: {}", name);
            return null;
        }
    }

    /**
     * 开窗组件，id拼接的分隔符
     */
    public static final String WINDOW_ID_SEPERATOR = "&&&&";

    /**
     * 元数据存储的dataId的key，用于批量提交参数替换，识别是哪个条目的id
     */
    public static final String MOBILE_CARD_DATAID_KEY = "mobile_card_dataId_key";

    /**
     * 用于表格排序
     */
    public static final String MOBILE_TABLE_SEQ = "mobile_table_seq";
    /**
     * 提交的card数据存储的key，用于批量提交存储所有card组件数据的key
     */
    public static final String MOBILE_SUBMIT_CARD_DATA_KEY = "mobile_submit_card_data_key";
    /**
     * cardList 新增套新增页面场景
     * 本地保存的card数据存储的key，用于存储本地保存操作当前页面的所有card组件数据的key
     */
    public static final String MOBILE_LOCAL_ADD_CARD_DATA_KEY = "mobile_local_add_card_data_key";
    /**
     * CardList 新增场景下 新增card数据标识位
     */
    public static final String MOBILE_CARD_ADD_DATA_TAG_KEY = "mobile_card_add_data_tag_key";

    /**
     * Card seq-key 标记key
     */
    public static final String MOBILE_CARD_SEQ_KEY = "mobile_card_seq_key";

    /**
     * 服务视图关键字
     */
    public static final String ACTION_CATEGORY_VIEW_CODE = "VIEWCODE";

    /**
     * 线程容器Key
     */
    public interface RuntimesContextKey {
        //VIEWCODE
        String VIEW_CODE = "VIEWCODE";
        //页面定义
        String PAGE_DEFINE = "pageDefine";
        //数据视图配置
        String DATA_VIEW_QUERYS = "dataViewQuerys";
    }
}