package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * <p>功能描述：鼎捷雅典娜PC UI Bot数据源实体</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotDataSourceDTO
 * @Author: zaregoto
 * @Date: 2023/2/27 16:30
 */
@Data
public class PcUiBotDataSourceDTO implements Serializable {

    private static final long serialVersionUID = 3954090756160345187L;
    /**
     * 对应的标题
     */
    private String title;
    /**
     * 数据源的名称
     */
    private String name;

    /**
     * 数据的key字段
     */
    private List<String> dataKeys;

    /**
     * 数据源类型
     */
    private String type;

    /**
     * tm中的actionid
     */
    private String actionId;

    /**
     * 数据的实际获取的action
     */
    private PcUiBotQueryAction action;

    /**
     * 查询的笔数
     */
    private Integer limit;

    /**
     * 是否为集合数据
     */
    private Boolean notArray;


    /**
     * 提供的数据源描述，如果数据源非esp的，或者通过actionid获取不到元数据的，可以通过这个集合来定义数据源的结果
     */
    private List<PcUiBotMetadataField> metadataFields;

    /**
     * 数据处理器
     */
    List<PcUiBotTmDataProcess> dataSourceProcessors;

    /**
     * 左边的数据
     */
    private PcUiBotDataSourceDTO left;

    /**
     * 右边的数据源
     */
    private List<PcUiBotDataSourceDTO> rightList;

    /**
     * 如果有多个字段重复，是否重写
     */
    private Boolean override = false;


    /**
     * 直接获取数据
     */
    private HashMap<String, Object> rawData;


    /**
     * 查询的数据源
     */
    private List<PcUiBotDataSourceDTO> unionItems;

    /**
     * 指定可以对union类型的数据做合并查询
     */
    private Boolean mergeQuery;
    /**
     * 扩展信息
     */
    private HashMap<String, Object> extendedData;

    /**
     * 参数入参类型
     * p1s1新增，实现“5207多档作业中，单身开窗入参支持单头字段”的需求
     */
    private String parameterType;

    public PcUiBotDataSourceDTO copyWithoutProcessor() {
        PcUiBotDataSourceDTO pcUiBotDataSourceDTO = new PcUiBotDataSourceDTO();
        pcUiBotDataSourceDTO.setName(this.getName());
        pcUiBotDataSourceDTO.setAction(this.getAction());
        pcUiBotDataSourceDTO.setType(this.getType());
        pcUiBotDataSourceDTO.setDataKeys(this.getDataKeys());
        pcUiBotDataSourceDTO.setActionId(this.getActionId());
        pcUiBotDataSourceDTO.setLimit(this.limit);
        pcUiBotDataSourceDTO.setMetadataFields(this.metadataFields);
        pcUiBotDataSourceDTO.setNotArray(this.notArray);
        pcUiBotDataSourceDTO.setOverride(this.override);
        pcUiBotDataSourceDTO.setRawData(this.rawData);
        pcUiBotDataSourceDTO.setMergeQuery(this.mergeQuery);

        if (this.left != null) {
            pcUiBotDataSourceDTO.setLeft(this.left.copyWithoutProcessor());
        }
        if (!CollectionUtils.isEmpty(rightList)) {
            List<PcUiBotDataSourceDTO> dataSourceBases = new ArrayList<>(rightList.size());
            for (PcUiBotDataSourceDTO dataSourceBase : this.rightList) {
                dataSourceBases.add(dataSourceBase.copyWithoutProcessor());
            }
            pcUiBotDataSourceDTO.setRightList(dataSourceBases);
        }
        if (!CollectionUtils.isEmpty(unionItems)) {
            List<PcUiBotDataSourceDTO> dataSourceBases = new ArrayList<>(unionItems.size());
            for (PcUiBotDataSourceDTO dataSourceBase : this.unionItems) {
                dataSourceBases.add(dataSourceBase.copyWithoutProcessor());
            }
            pcUiBotDataSourceDTO.setUnionItems(dataSourceBases);
        }
        return pcUiBotDataSourceDTO;
    }

}
