package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>功能描述：鼎捷雅典娜PC UI Bot数据集实体</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotDataSourceSetDTO
 * @Author: zaregoto
 * @Date: 2023/2/27 16:30
 */
@Data
public class PcUiBotDataSourceSetDTO {

    public static PcUiBotDataSourceSetDTO create(PcUiBotDataSourceDTO dataSourceBase) {
        PcUiBotDataSourceSetDTO dataSourceSet = new PcUiBotDataSourceSetDTO();
        List<PcUiBotDataSourceDTO> dataSourceList = new ArrayList<>();
        dataSourceList.add(dataSourceBase);
        dataSourceSet.setDataSourceList(dataSourceList);
        return dataSourceSet;
    }

    /**
     * 判断是否存在指定的数据源
     *
     * @param name
     * @return
     */
    public boolean containsKey(String name) {
        if (!CollectionUtils.isEmpty(dataSourceList)) {
            for (PcUiBotDataSourceDTO dataSourceDTO : dataSourceList) {
                if (name.equals(dataSourceDTO.getName())) {
                    return true;
                }
            }
        }
        return false;
    }

    public PcUiBotDataSourceSetDTO append(PcUiBotDataSourceDTO dataSourceBase) {
        if (dataSourceList == null) {
            this.dataSourceList = new ArrayList<>();
        }
        dataSourceList.add(dataSourceBase);
        return this;
    }

    /**
     * 查询的数据源
     */
    private List<PcUiBotDataSourceDTO> dataSourceList;

    private String mainDatasource;

    public String getMainDatasource() {
        if (StringUtils.hasText(mainDatasource)) {
            return mainDatasource;
        }
        if (CollectionUtils.isEmpty(dataSourceList)) {
            return null;
        }
        return this.dataSourceList.get(0).getName();
    }

    /**
     * 获取第一个查询条件的title，不存在则用name
     *
     * @return
     */
    @JsonIgnore
    public String getMainDatasourceTitle() {
        if (CollectionUtils.isEmpty(dataSourceList)) {
            return null;
        }
        String title = this.dataSourceList.get(0).getTitle();
        String name = this.dataSourceList.get(0).getName();
        return org.apache.commons.lang3.StringUtils.isNotBlank(title) ? title : name;
    }

    public void setMainDatasource(String mainDatasource) {
        this.mainDatasource = mainDatasource;
        if (this.getFirstDataQuery() != null) {
            this.getFirstDataQuery().setName(mainDatasource);
        }
    }

    /**
     * 全局数据处理器
     */
    private List<PcUiBotTmDataProcess> dataProcess;

    @JsonIgnore
    public String getFirstActionId() {
        if (CollectionUtils.isEmpty(dataSourceList)) {
            return null;
        }
        return this.dataSourceList.get(0).getActionId();
    }

    @JsonIgnore
    public boolean isEmpty() {
        return CollectionUtils.isEmpty(dataSourceList);
    }

    @JsonIgnore
    public PcUiBotDataSourceDTO getFirstDataQuery() {
        if (CollectionUtils.isEmpty(dataSourceList)) {
            return null;
        }
        return this.dataSourceList.get(0);
    }

    @JsonIgnore
    public PcUiBotQueryAction getFirstAction() {
        if (CollectionUtils.isEmpty(dataSourceList)) {
            return null;
        }
        return this.dataSourceList.get(0).getAction();
    }

    @JsonIgnore
    public List<String> getDataKeys() {
        if (CollectionUtils.isEmpty(dataSourceList)) {
            return null;
        }
        return this.dataSourceList.get(0).getDataKeys();
    }

}
