package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：数据视图查询集：用来查询视图的业务数据</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotDataViewQuerySetDTO.java
 * @Author: wangjwc
 * @Date: created at 2023/12/26 17:30
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class PcUiBotDataViewQuerySetDTO {

    /**
     * 视图编码
     */
    private String code;

    /**
     * 排序
     */
    private List<Map<String, Object>> orderList;

    /**
     * 过滤
     */
    private List<Map<String, Object>> queryConditions;

    /**
     * 回参
     */
    private Map<String, Object> returnFields;

    /**
     * 表格
     */
    private List<Map<String, Object>> tables;
}
