package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>功能描述：基础资料录入页面的的定义</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotDoubleDocumentPageDefine.java
 * @Author: wangjwc
 * @Date: created at 2023/11/16 14:46
 */
@Data
public class PcUiBotDoubleDocumentPageDefine extends PcUiBotPageDefine {
    /**
     * 版本号
     */
    private String version;

    private String dataSourceName;

    /**
     * 编辑类型，复制：copy；维护：maintain；新增：add
     */
    private String editType;

    private String datamap;

    /**
     * 数据视图查询dto
     */
    private List<PcUiBotDataViewQueryDTO> dataViewQueryList;

    public List<PcUiBotDataViewQueryDTO> convertDataViewQueryList(List<PcUiBotTmDataViewQuery> tmDataViewQueryList) {
        if (CollectionUtils.isEmpty(tmDataViewQueryList)) {
            return null;
        }
        List<PcUiBotDataViewQueryDTO> list = new ArrayList<>(tmDataViewQueryList.size());
        for (PcUiBotTmDataViewQuery tmDataViewQuery : tmDataViewQueryList) {
            PcUiBotDataViewQueryDTO dataViewQueryDTO = new PcUiBotDataViewQueryDTO();
            dataViewQueryDTO.setViewName(tmDataViewQuery.getName());
            dataViewQueryDTO.setViewCode(tmDataViewQuery.getCode());
            dataViewQueryDTO.setSort(tmDataViewQuery.getSort());
            dataViewQueryDTO.setIsDefault(tmDataViewQuery.getIsDefault());
            list.add(dataViewQueryDTO);
        }
        return list;
    }

    /**
     * 数据源转为数据视图；数据源没有viewCode；后面通过是否含有viewCode，区分视图类型
     *
     * @param dataSourceSetDto
     * @return
     */
    public PcUiBotDataViewQueryDTO dataSourceToView(PcUiBotDataSourceSetDTO dataSourceSetDto) {
        PcUiBotDataViewQueryDTO dataViewQuery = new PcUiBotDataViewQueryDTO();
        dataViewQuery.setViewName(dataSourceSetDto.getMainDatasourceTitle());
        dataViewQuery.setSort(Long.MAX_VALUE);
        dataViewQuery.setDataSourceSet(dataSourceSetDto);
        return dataViewQuery;
    }

}
