package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.*;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocProxyUserResult;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.impl.DigiwinEocProxyServiceImpl;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * <p>功能描述：鼎捷雅典娜PC UI Bot页面相关上下文</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotAction
 * @Author: zaregoto
 * @Date: 2023/2/27 16:30
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class PcUiBotExecuteContext implements Serializable {

    private static final long serialVersionUID = -6271091374311020570L;
    /**
     * 语言别
     */
    private String locale;

    /**
     * 客户端来源
     */
    private String clientAgent;
    /**
     * 客户端类型 standardweb:标准前端web
     */
    private String agentType;

    /**
     * 执行者performer或者当责者charge
     */
    private String identity;

    /**
     * 项目名称
     */
    private String tmProjectId;
    /**
     * 任务相关的数据
     */
    private DigiwinAtmcProjectData projectData;

    /**
     * projectCardId项目卡的Id，用于将来防重复提交
     */
    private Long projectCardId;

    /**
     * 当责者id，取projectData中的chargeId，调用action/show接口的时候projectData没有这个参数，所以用这个接收，来进行按钮的判断
     */
    private String chargeId;

    private DigiwinAtmcTaskWithBacklogData taskWithBacklogData;

    /**
     * 所有任务的bpm 参数数据，给
     */
    private List<Map<String, Object>> allBpmData;

    private List<DigiwinAtmcTaskWithBacklogData> taskWithBacklogDataList;

    /**
     * 异动数据
     */
    @JsonIgnore
    private List<Map> abnormalData;

    /**
     * 主卡关联的异动数据卡
     */
    @JsonIgnore
    private List<DigiwinAtmcBpmActivityWorkitem> abnormalCards;

    /**
     * 88:预期任务；89：异动数据异常排除
     */
    private Integer taskType;
    /**
     * 代办项id，一般再提交的时候用
     */
    private Long backlogId;

    /**
     * ptmBacklogId
     */
    private String ptmBacklogId;

    /**
     * 流程序号
     */
    private String processSerialNumber;

    /**
     * 数据一致性异常排除任务卡id
     */
    private Long abnormalWorkitemId;

    private DigiwinAtmcBpmActivityWorkitem approvalInfo;

    /**
     * 关卡名称
     */
    private String tmActivityId;

    /**
     * 关卡名称
     */
    private String tmActivityName;

    /**
     * 代理的token
     */
    private String proxyToken;
    /**
     * 登陆用户
     */
    private PcUiBotAuthoredUser authoredUser;

    /**
     * 租户ID
     */
    private String tenantId;

    /**
     * 页面场景
     * [project-card,project-detail,task-card,task-detail]
     */
    private String pageCode;

    /**
     * 数据的状态
     * waiting 待处理
     * tracing 追踪中
     * completed 已完成
     * processing 处理中
     */
    private String dataStateCode;


    /**
     * 短地址应用的设备类型，目前仅有email
     */
    private String deviceType;


    /**
     * 短地址应用的设备值，当deviceType为email时，表示收件人的email地址
     */
    private String deviceValue;

    /**
     * 活动形态分类
     */
    private String pattern;

    /**
     * 活动形态类型
     */
    private String category;

    /**
     * 根据标签来执行
     */
    private PcUiBotRelationTag relationTag;

    /**
     * 营运单元
     */
    private Map<String, Object> businessUnit;

    /**
     * 由前端确定，是否是开窗，如果是开窗，不走模板
     */
    private Boolean openWindow;

    /**
     * 主要用于所属领域
     */
    private List<String> domain;

    /**
     * 开窗类型
     */
    private String openWindowType;

    /**
     * 任务、项目是否为被分享的
     */
    private Boolean isShared;

    /**
     * 历史任务中的摘要信息
     * history
     */
    private String flag;

    /**
     * 编辑类型，复制：copy；维护：maintain；新增：add；查询：query
     */
    private String editType;

    /**
     * 是否是历史项目/任务
     */
    private Boolean isHistory;

    /**
     * 设计器
     */
    private Boolean isDesigner;

    /**
     * 是否已为回收站请求
     */
    private Boolean isRecycle;

    /**
     * 启用精简报文，默认不开启
     */
    private Boolean enableSimplifyPack = Boolean.FALSE;

    /**
     * 活动定义的全局参数
     * 目前用到的币别
     * currency {小数点位数 ：decimal_places ,取数方式：decimal_places_type}
     */
    private Map<String, Object> activityParameter;

    /**
     * 是否为平铺树结构TABLE
     */
    @JsonIgnore
    private Boolean isRowSpanTree;

    /**
     * 是否走客制
     */
    private Boolean isCustomize;


    /**
     * 如果是客制，可以要求返回原始的布局到客制组件里，供前端使用
     */
    private Boolean needOriginalLayout;

    /**
     * 调用链ID
     */
    private String traceId;

    /**
     * 数据来源：PTM表示来源于PTM，其他表示ATMC
     */
    private String dataFrom;

    /**
     * 表格名称
     */
    private String gridSchema;

    /*   *//**
     * 词库开关
     * true：针对于当前类型的任务/项目卡开启词库功能
     * false：关闭词库功能
     * 不配置默认关闭
     *//*
    private Boolean openWordsLibrary = Boolean.FALSE;*/
    /**
     * 流程数据
     */
    private Map<String, Object> bpmData;

    /**
     * 项目流程数据
     */
    private Map<String, Object> projectBpmData;

    /**
     * 是否存在签核
     */
    private Boolean hasApprove;

    /**
     * 提交唯一键
     */
    private Integer submitId;

    /**
     * 控制表格是否自动高度
     * autoHeight：自动高度
     * 默认没有配置为不自动高度
     */
    private String scrollType;

    /**
     * 是不是超级管理员
     */
    private Boolean isSuperAdmin;

    /**
     * 是否是任务引擎标记
     */
    private Boolean isTaskEngine;

    /**
     * 判断是否通过adsc模块查应用数据
     */
    private Boolean fromAdsc = false;

    /**
     * 移动任务卡/数据录入/发起项目/项目卡数据id
     */
    private String mobileDataId;

    /**
     * 主数据源名称 -- 用于判断是否是主数据源
     */
    private String mainDataSourceName;

    /**
     * 应用ID
     */
    private String application;

    /**
     * 第三方集成 跳转数据驱动任务卡 来源类型
     */
    private String sourceType;


    /**
     * 用于type=20时，detailPage是否开兄弟详情
     */
    private Boolean openDetailPage = false;


    public static PcUiBotExecuteContext create(String locale, String tenantId, String mobileDataId) {
        return PcUiBotExecuteContext.builder()
                .clientAgent(PcUiBotConstants.WEB_PLATFORM)
                .locale(locale)
                .authoredUser(null)
                .tenantId(tenantId)
                .mobileDataId(mobileDataId)
                .build();
    }

    public void appendPageInfo(String pageCode, String tmProjectId, String tmActivityId, String identity, Boolean isShared) {
        this.setIdentity(identity);
        this.setTmProjectId(tmProjectId);
        this.setPageCode(pageCode);
        this.setTmActivityId(tmActivityId);
        this.setIsShared(isShared);
    }

    public void appendPageInfoAndSuperAdmin(String pageCode, String tmProjectId, String tmActivityId, String identity,
                                            Boolean isShared, Boolean isHistory, Boolean isSuperAdmin) {
        this.setIdentity(identity);
        this.setTmProjectId(tmProjectId);
        this.setPageCode(pageCode);
        this.setTmActivityId(tmActivityId);
        this.setIsShared(isShared);
        this.setIsHistory(isHistory);
        this.setIsSuperAdmin(isSuperAdmin);
    }


    /**
     * 任务相关的数据
     */
    public DigiwinAtmcTaskWithBacklogData getTaskWithBacklogData() {
        if (this.taskWithBacklogData != null) {
            return this.taskWithBacklogData;
        }
        if (!CollectionUtils.isEmpty(taskWithBacklogDataList)) {
            this.taskWithBacklogData = taskWithBacklogDataList.get(0);
            return this.taskWithBacklogData;
        }
        return null;
    }


    /**
     * 任务相关的数据
     */
    public void setTaskWithBacklogData(DigiwinAtmcTaskWithBacklogData taskWithBacklogData) {
        this.taskWithBacklogData = taskWithBacklogData;
        if (taskWithBacklogDataList == null) {
            this.taskWithBacklogDataList = new ArrayList<>();
            this.taskWithBacklogDataList.add(this.taskWithBacklogData);
        }
    }


    public String getEditType() {
        return editType;
    }

    public void setEditType(String editType) {
        this.editType = editType;
    }

    public Boolean getIsRowSpanTree() {
        if (isRowSpanTree == null) {
            isRowSpanTree = false;
        }
        return isRowSpanTree;
    }

    public void setIsRowSpanTree(Boolean isRowSpanTree) {
        this.isRowSpanTree = isRowSpanTree;
    }


    @JsonIgnore
    public DigiwinAtmcBacklogData getFirstBacklog() {
        if (this.getTaskWithBacklogData() != null
                && this.getTaskWithBacklogData().getBacklog() != null
                && this.getTaskWithBacklogData().getBacklog().size() > 0) {
            return this.getTaskWithBacklogData().getBacklog().get(0);
        }
        return null;
    }

    /**
     * 任务or项目是被分享的
     *
     * @return
     */
    @JsonGetter("isShared")
    public boolean isShared() {
        return Boolean.TRUE.equals(isShared);
    }

    public Long getBacklogId() {
        if (backlogId == null && getFirstBacklog() != null) {
            return getFirstBacklogId();
        }
        return backlogId;
    }

    public void setBacklogId(Long backlogId) {
        this.backlogId = backlogId;
    }


    @JsonIgnore
    public Long getFirstBacklogId() {
        if (this.getTaskWithBacklogData() != null
                && this.getTaskWithBacklogData().getBacklog() != null
                && this.getTaskWithBacklogData().getBacklog().size() > 0) {
            return this.getTaskWithBacklogData().getBacklog().get(0).getBacklogId();
        }
        return -1L;
    }

    /**
     * 活动信息 存入执行上下文
     */
    public void appendTmActivityInfo(PcUiBotTmActivity tmActivity) {
        if (!StringUtils.hasLength(this.getTmActivityId())) {
            this.setTmActivityId(tmActivity.getActivityId());
        }
        if (!StringUtils.hasLength(this.getTmActivityName())) {
            this.setTmActivityName(tmActivity.getActivityNameByLocale());
        }
        this.setCategory(tmActivity.getCategory());
        this.setPattern(tmActivity.getPattern());
        this.setActivityParameter(tmActivity.getActivityParameter());
        this.setIsCustomize(null != tmActivity.getPages() ? tmActivity.getPages().getIsCustomize() : null);
        // 2023-4-25 modify by xuxx: pattern和页面（pages）上只要有一个设置了客制 ，则为客制；暂不支持客制基础资料配置标准双档子页签；
        if (this.getIsCustomize() != null && this.getIsCustomize()) {
            this.setPattern(PcUiBotActivityConstants.PATTERN_CUSTOM);
        }
        if (PcUiBotActivityConstants.PATTERN_CUSTOM.equals(this.getPattern())) {
            this.setIsCustomize(true);
        }
        this.setNeedOriginalLayout(null != tmActivity.getPages() ? tmActivity.getPages().getNeedOriginalLayout() : null);
        PcUiBotRelationTag relationTag = new PcUiBotRelationTag();

        relationTag.setIdentity(this.identity);
        relationTag.setActivityId(tmActivity.getActivityId());
        this.setDomain(tmActivity.getPages().getDomain());
        this.setRelationTag(relationTag);
        // this.setOpenWordsLibrary(tmActivity.getPages().getOpenWordsLibrary());
        this.setIsTaskEngine(tmActivity.isTaskEngine());
        this.setEnableSimplifyPack(tmActivity.getPages().getEnableSimplifyPack());
        this.setApplication(tmActivity.getApplication());
    }

    private <T extends PcUiBotExecuteContext> void copyTo(T newExecuteContext) {
        newExecuteContext.setMainDataSourceName(this.mainDataSourceName);
        newExecuteContext.setMobileDataId(this.mobileDataId);
        newExecuteContext.setActivityParameter(this.getActivityParameter());
        newExecuteContext.setAuthoredUser(this.authoredUser);
        newExecuteContext.setCategory(this.category);
        newExecuteContext.setBusinessUnit(this.businessUnit);
        newExecuteContext.setClientAgent(this.clientAgent);
        newExecuteContext.setDataStateCode(this.getDataStateCode());
        newExecuteContext.setDeviceType(this.deviceType);
        newExecuteContext.setDeviceValue(this.deviceValue);
        newExecuteContext.setIsCustomize(this.isCustomize);
        newExecuteContext.setNeedOriginalLayout(this.needOriginalLayout);
        newExecuteContext.setIsShared(this.isShared);
        newExecuteContext.setIsRecycle(this.isRecycle);
        newExecuteContext.setOpenWindow(this.openWindow);
        newExecuteContext.setOpenWindowType(this.openWindowType);
        newExecuteContext.setIdentity(this.identity);
        newExecuteContext.setLocale(this.locale);
        newExecuteContext.setPageCode(this.pageCode);
        newExecuteContext.setPattern(this.pattern);
        newExecuteContext.setProxyToken(this.proxyToken);
        newExecuteContext.setRelationTag(this.relationTag);
        newExecuteContext.setTenantId(this.tenantId);
        newExecuteContext.setTmActivityId(this.tmActivityId);
        newExecuteContext.setTmActivityName(this.tmActivityName);
        newExecuteContext.setTmProjectId(this.tmProjectId);
        newExecuteContext.setAllBpmData(this.allBpmData);
        newExecuteContext.setBpmData(this.bpmData);
//        newExecuteContext.setTaskWithBacklogData(this.taskWithBacklogData);
        newExecuteContext.setProjectData(this.projectData);
        newExecuteContext.setTaskWithBacklogDataList(this.taskWithBacklogDataList);
        newExecuteContext.setAbnormalData(this.abnormalData);
        newExecuteContext.setAbnormalCards(this.abnormalCards);
        newExecuteContext.setTaskType(this.taskType);
        newExecuteContext.setAbnormalWorkitemId(this.abnormalWorkitemId);
        newExecuteContext.setTraceId(this.traceId);
        newExecuteContext.setDataFrom(this.dataFrom);
        newExecuteContext.setEditType(this.editType);
        newExecuteContext.setIsHistory(this.isHistory);
        newExecuteContext.setIsSuperAdmin(this.isSuperAdmin);
        newExecuteContext.setIsTaskEngine(this.isTaskEngine);
        newExecuteContext.setHasApprove(this.hasApprove);
        newExecuteContext.setFromAdsc(this.fromAdsc);
        newExecuteContext.setProjectBpmData(this.projectBpmData);
        newExecuteContext.setSubmitId(this.submitId);
        newExecuteContext.setProjectCardId(this.projectCardId);
        newExecuteContext.setChargeId(this.chargeId);
        newExecuteContext.setAgentType(this.agentType);
        newExecuteContext.setEnableSimplifyPack(this.enableSimplifyPack);
        newExecuteContext.setApplication(this.application);
    }

    @Override
    public PcUiBotExecuteContext clone() {
        PcUiBotExecuteContext executeContext = new PcUiBotExecuteContext();
        this.copyTo(executeContext);
        return executeContext;
    }

    public void appendTaskData(DigiwinAtmcActivityData activityData) {
        if (activityData != null && activityData.getProject() != null) {

            this.setProjectData(activityData.getProject());
            this.setAbnormalData(activityData.getAbnormalData());
            this.setAbnormalCards(activityData.getAbnormalCards());
            this.setTmProjectId(activityData.getProject().getTmProjectId());
            this.setTaskWithBacklogDataList(activityData.getTasks());
            this.setTaskType(activityData.getType());
            this.setAbnormalWorkitemId(activityData.getAbnormalWorkitemId());
            approvalInfo = new DigiwinAtmcBpmActivityWorkitem();
            if (activityData.getReapprovalInfo() != null) {
                approvalInfo.setComment(activityData.getReapprovalInfo().getComment());
                approvalInfo.setClosedTime(activityData.getReapprovalInfo().getClosedTime());
                approvalInfo.setPerformerName(activityData.getReapprovalInfo().getPerformerName());
                approvalInfo.setSubState(activityData.getReapprovalInfo().getSubState());
            }

            allBpmData = new ArrayList<>();
            if (activityData.getTasks() != null && activityData.getTasks().size() >= 1) {
                this.setTraceId(activityData.getTasks().get(0).getTraceId());
                for (DigiwinAtmcTaskWithBacklogData withBacklogData : activityData.getTasks()) {
                    if (!CollectionUtils.isEmpty(withBacklogData.getBacklog())) {
                        this.setBacklogId(withBacklogData.getBacklog().get(0).getBacklogId());
                    }
                    this.setBpmData(withBacklogData.getBpmData());
                    this.setProcessSerialNumber(withBacklogData.getProcessSerialNumber());
                    if (withBacklogData.getBpmData() != null && !withBacklogData.getBpmData().isEmpty()) {
                        allBpmData.add(withBacklogData.getBpmData());
                    }
                }
            }
            this.setTenantId(activityData.getProject().getTenantId());
            if (!CollectionUtils.isEmpty(activityData.getTasks())) {
                this.setBusinessUnit(activityData.getTasks().get(0).getBusinessUnit());
                if (StringUtils.hasText(activityData.getTasks().get(0).getProxyToken())) {
                    this.setProxyToken(activityData.getTasks().get(0).getProxyToken());
//                    AppAuthContextHolder.getContext().setProxyToken(this.getProxyToken());
                }
            }
            this.setDataFrom(activityData.getDataFrom());
            if (this.isOwnerBacklog()) {
                isShared = false;
            }
            this.setHasApprove(activityData.getHasApprove());
            this.setProjectBpmData(activityData.getProject().getProjectBpmData());
            this.setSubmitId(activityData.getSubmitId());
            // 添加projectCardId
            if (this.getProjectData() != null) {
                this.projectCardId = this.getProjectData().getProjectCardId();
                this.chargeId = this.getProjectData().getChargeId();
            }
        }
    }

    /**
     * 任务or项目不是被分享的
     *
     * @return
     */
    @JsonIgnore
    public boolean isOwnerBacklog() {
        if (this.getAuthoredUser() == null) {
            return false;
        }
        String currentUserId = this.getAuthoredUser().getUserId();
        // 针对不是项目详情的分享
        if (!UiBotDesignerService.PAGECODE_PROJECT_DETAIL.equals(pageCode)) {
            DigiwinAtmcBacklogData backlogData = getFirstBacklog();
            String performerId = backlogData == null ? null : backlogData.getPerformerId();
            String backlogPerformId = backlogData == null ? null : backlogData.getBacklogPerformId();
//            String personInCharge = (String) Optional.ofNullable(getBpmData())
//                    .orElse(Maps.newHashMap())
//                    .get(PcUiBotActivityConstants.PERSON_IN_CHARGE);
            // 是不是超级管理员
            boolean isSuperAdmin = BooleanUtil.isTrue(this.getIsSuperAdmin());
            // 是不是超级管理员并且是任务引擎
            boolean isSuperAndTaskEngine = isSuperAdmin
                    && PcUiBotConstants.ACTION_CATEGORY_BPM_PTM.equalsIgnoreCase(this.getDataFrom());
            // 1.当前登录人等于执行者
            // 2.当前登录人等于当责者
            // 3.登录人是超级管理员并且为任务引擎
            // 需求单：https://athena-devops-zentao.digiwincloud.com.cn/story-view-7124.html
            if (StrUtil.equals(performerId, currentUserId)
                    || StrUtil.equals(backlogPerformId, currentUserId)
                    /**
                     * 任务卡应该只能被执行者及其代理人、超级管理员提交。
                     * 只要当责者不是任务卡的执行者、代理人或者超级管理员，那当责者就不能提交该任务卡（97213）
                     */
//                    || StrUtil.equals(personInCharge, currentUserId)
                    || isSuperAndTaskEngine) {
                return Boolean.TRUE;
            }
        } else { // 项目详情的权限
            if (this.chargeId != null) {
                // 当前登录人等于当责者或是代理人
                return StrUtil.equals(this.chargeId, currentUserId) || isProxy(this.getAuthoredUser(), chargeId);
            }
        }
        return Boolean.FALSE;
    }

    public static boolean isProxy(PcUiBotAuthoredUser currentUser, String userId) {
        DigiwinEocProxyService digiwinEocProxyService = SpringContextHolder.getBean(DigiwinEocProxyServiceImpl.class);
        // 获取当前用户的代理人
        List<EocProxyUserResult.EocProxyUser> proxyTargetUsers = digiwinEocProxyService.getProxyTargetUsers(currentUser.getUserId(), currentUser.getToken());
        if (CollectionUtils.isEmpty(proxyTargetUsers)) {
            return false;
        }
        // 判断用户是否相等
        for (EocProxyUserResult.EocProxyUser proxyTargetUser : proxyTargetUsers) {
            if (Objects.equals(proxyTargetUser.getUserId(), userId)) {
                return true;
            }
        }
        return false;
    }
}
