package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import java.util.List;

/**
 * <p>功能描述：鼎捷雅典娜PC UI Bot标签组</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotGroupMetadataField
 * @Author: zaregoto
 * @Date: 2023/2/27 16:30
 */
@Data
public class PcUiBotGroupMetadataField {
    /**
     * 显示的标题
     */
    private String title;

    /**
     * TAG 编码
     */
    private String tagCode;


    /**
     * 根据内容计算出来的合理宽度
     */
    @JsonIgnore
    private int displayWidth;

    /**
     * 是否显示group 下面栏位是否显示标题
     */
    private String groupFieldShowTitle;

    /**
     * 字段
     */
    private List<PcUiBotMetadataField> metadataFields;

    /**
     * TAG 类型   :
     * NAME_CODE：内含外显
     * FORM_GROUP：表单组合显示
     */
    private String tagType;

    /**
     * 包含的列超过1个
     */
    @JsonIgnore
    private boolean hasManyColumn;


}
