package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTagDefinition;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：鼎捷雅典娜PC UI Bot元数据字段描述</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotMetadataField
 * @Author: zaregoto
 * @Date: 2023/2/27 16:30
 */
@Data
public class PcUiBotMetadataField implements Serializable {
    private static final long serialVersionUID = 4957062090526593690L;
    /**
     * 字段编码
     */
    private String name;

    /**
     * 所在路径
     */
    private String path;

    /**
     * 是否必填
     */
    private boolean required;

    /**
     * 字段描述
     */
    private String description;

    /**
     * 字段备注
     */
    private String remark;

    /**
     * 是否主键
     */
    private String dataKey;

    private boolean businessKey;

    /**
     * 数据类型
     */
    private String dataType;

    /**
     * 是不是简单的字段，非集合，非对象
     *
     * @return
     */
    @JsonIgnore
    public boolean isSimpleField() {
        if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(this.getDataType())) {
            return false;
        }
        return !this.isArray();
    }

    @JsonIgnore
    public boolean isObjectField() {
        return PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(this.getDataType());
    }

    /**
     * 根据内容计算出来的合理宽度
     */
    @JsonIgnore
    private int displayWidth;

    /**
     * 长度与精度
     */
    private PcUiBotMetadataPrecision precision;

    private Object objectData;

    /**
     * 可排序字段
     */
    private Boolean canSort;

    /**
     * 是否可筛选
     */
    private Boolean canFilter;

    /**
     * 字段类型
     */
    private String fieldType;

    /**
     * 是否可以编辑
     */
    private boolean canEdit;

    /**
     * 字段的标签--原则上不存在相同的标签，设计器阶段应该过滤掉
     */
    private List<PcUiBotTagDefinition> tagDefinitions;

    /**
     * 拥有的字段
     */
    private List<PcUiBotMetadataField> subFields;

    @JsonIgnore
    private List<PcUiBotMetadataField> exportTableFields;

    /**
     * 是否多笔数据
     */
    private boolean array;


    /**
     * UIBOT-属性 来源API
     */
    @JsonIgnore
    private String sourceApi;

    @JsonIgnore
    private boolean isHead;
//
//    /**
//     *  UIBOT-属性
//     */
//    private boolean checkItem;

    /**
     * UIBOT-属性
     */
    @JsonIgnore
    private String clientAgent;

    /**
     * 如果字段有下拉列表，则存放下拉列表对应的key
     * 对应元数据中的  enum_key
     */
    private String enumKey;

    /**
     * 把子节点变成带路径的结构
     */
    @JsonIgnore
    private Map<String, PcUiBotMetadataField> fieldMap;

    /**
     * 父字段
     */
    @JsonIgnore
    private PcUiBotMetadataField parentField;

    /**
     * 字段组集合
     */
    @JsonIgnore
    private List<PcUiBotGroupMetadataField> groupMetadataFields;

    /**
     * 字段组
     */
    private PcUiBotGroupMetadataField groupMetadataField;

    public PcUiBotMetadataField findByFullPath(String fullName) {
        if (StringUtils.isEmpty(fullName)) {
            return null;
        }
        if (this.getFullName().equals(fullName)) {
            return this;
        }
        if (fullName.startsWith(this.getName() + ".")) {
            String headName = this.getName() + ".";
            String path = fullName.substring(headName.length());
            //String path = fullName.replace(this.getName()+".","");

            return findByPath(path.split("\\."));

        }
        return null;

    }

    public void addField(PcUiBotMetadataField metadataField) {
        if (exist(metadataField.getName())) {
            return;
        }
        this.getSubFields().add(metadataField);
        if (this.getFieldMap() == null) {
            this.setFieldMap(new HashMap<>());
        }
        this.getFieldMap().put(metadataField.getName(), metadataField);

    }

    public PcUiBotMetadataField getField(String name) {
        if (exist(name)) {
            return null;
        }
        return this.getFieldMap().get(name);
    }

    public boolean exist(String name) {
        if (this.getFieldMap() == null) {
            flatMetaData(this.getParentField());
        }
        return this.getFieldMap() != null && this.getFieldMap().containsKey(name);
    }


    public void flatMetaData(PcUiBotMetadataField parentField) {
        if (CollectionUtils.isEmpty(this.getSubFields())) {
            return;
        }
        Map<String, PcUiBotMetadataField> fieldMap = new HashMap<>();
        this.setFieldMap(fieldMap);
        this.setParentField(parentField);
        for (PcUiBotMetadataField subField : this.getSubFields()) {
            fieldMap.put(subField.getName(), subField);
            String path = this.getFullName();
            subField.setPath(path);
            subField.flatMetaData(this);
        }
    }

    public void flatMetaDataNotFlatPath(PcUiBotMetadataField parentField) {
        if (CollectionUtils.isEmpty(this.getSubFields())) {
            return;
        }
        Map<String, PcUiBotMetadataField> fieldMap = new HashMap<>();
        this.setFieldMap(fieldMap);
        this.setParentField(parentField);
        for (PcUiBotMetadataField subField : this.getSubFields()) {
            fieldMap.put(subField.getName(), subField);
            subField.setPath(subField.getPath());
            subField.flatMetaDataNotFlatPath(this);
        }
    }

    public PcUiBotMetadataField findByPath(String[] paths) {
        if (paths == null || paths.length == 0) {
            return null;
        }
        String firstPath = paths[0];
        if (this.getFieldMap() == null || !this.getFieldMap().containsKey(firstPath)) {
            return null;
        } else {
            if (paths.length == 1) {
                return this.getFieldMap().get(firstPath);
            }
            return this.getFieldMap().get(firstPath).findByPath(ArrayUtils.subarray(paths, 1, paths.length));
        }
    }

    /**
     * UIBOT-属性 操作符
     */
    @JsonIgnore
    private List<PcUiBotOperationDTO> operations;

//    /**
//     *  UIBOT-属性 是否是分组组件
//     */
//    private GroupSetting group;

    /**
     * UIBOT-属性 UIBOT模拟出来
     */
    private String uiBot;

    /**
     * 是否支持跳转
     * true:支持
     * false:不支持
     */
    private Boolean isNavigate = Boolean.FALSE;


    @JsonIgnore
    public String getFullName() {
        if (StringUtils.hasText(this.getPath())) {
            return this.getPath() + "." + this.getName();
        } else {
            return this.getName();
        }
    }

    @JsonIgnore
    public boolean canNotEdit() {
        return !this.canEdit;
    }

    public String toString() {
        return this.getName();
    }

    public PcUiBotMetadataField clone(PcUiBotMetadataField parentMetadataField, List<PcUiBotMetadataField> sonTagFields) {
        PcUiBotMetadataField newMetadataField = new PcUiBotMetadataField();
        newMetadataField.setDataType(this.getDataType());
        newMetadataField.setDataKey(this.getDataKey());
        newMetadataField.setRemark(this.getRemark());
        newMetadataField.setDescription(this.getDescription());
        newMetadataField.setRequired(this.isRequired());
        newMetadataField.setName(this.getName());
        newMetadataField.setArray(this.isArray());
        newMetadataField.setCanEdit(this.isCanEdit());
        newMetadataField.setTagDefinitions(this.getTagDefinitions());
        newMetadataField.setFieldType(this.getFieldType());
        newMetadataField.setSubFields(sonTagFields);
        newMetadataField.setPath(this.getPath());
        newMetadataField.setParentField(parentMetadataField);
        newMetadataField.setEnumKey(this.getEnumKey());
        return newMetadataField;
    }
}
