package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotOpenWindowDefineDTO;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：鼎捷雅典娜PC UI Bot操作实体定义</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotOperationDTO
 * @Author: zaregoto
 * @Date: 2023/2/27 16:30
 */
@Data
public class PcUiBotOperationDTO implements Serializable {
    private static final long serialVersionUID = 250465860774827811L;

    private String id;
    private String title;
    private String type;
    private int sequence;
    private String targetDetailField;
    private String sequenceField;
    private String description;
    private String operate;
    /**
     * 操作辅助信息 删除行使用到
     */
    private String operateTarget;
    /**
     * 匹配信息
     */
    private PcUiBotAttachDTO attach;
    private String operateScript;

    /**
     * 条件开窗配置
     * 脚本
     */
    private String openWindowConditional;

    /**
     * 禁用条件
     */
    private PcUiBotCondition condition;

    /**
     * 隐藏条件
     */
    private PcUiBotCondition hidden;

    /**
     * 控制样式：默认在下面
     */
    private String position;

    private String icon;

    private Boolean display;

    private List<String> cleanFields;

    /**
     * 开窗定义
     */
    private PcUiBotOpenWindowDefineDTO openWindowDefine;

    /**
     * 提交按钮，适用于删除等Operation操作
     */
    private PcUiBotSubmitAction submitAction;

    private PcUiBotRelationTag relationTag;
    private JSONObject rule;
    private String pageCode;

    /**
     * 编辑器,过期的做法，后续全部通过editor属性来动态创建
     */
    @Deprecated
    private PcUiBotEditorDefineDTO editorDefine;

    /**
     * 编辑器
     */
    private Map<String, Object> editor;

    /**
     *
     */
    private PcUiBotOperationAPIDefineDTO apiDefine;
    /**
     * table 前端二次过滤脚本
     */
    private PcUiBotScriptFilterDTO scriptCondition;

    /**
     * 发票
     */
    private List<PcUiBotReturnFields> backFills;

    /**
     * 扩展字段信息
     */
    private Map<String, Object> extendedFields;

    private JSONObject confirm;

    /**
     * 目标数据源
     */
    private String target;
    /**
     * 存在的值：row/all/line
     */
    private String mode;
    /**
     * 不为空且mode等row，表示操作放到某个字段中，为空表示放在行内或其他地方 line
     */
    private String applyToField;

    /**
     * 任务已关闭，是否还需要apply该operation
     */
    private Boolean applyAlthoughFinished;


    /**
     * 是否是客制 ture：是客制；false：非客制（默认不填为非客制）
     */
    private Boolean isCustomize;

    /**
     * 客制type
     */
    private String customType;


    private String schema;

    /**
     * 用于标记开窗是否需要排他
     * true：需要排他
     * false:不需要排他
     * 可以不配，不配默认false
     */
    private Boolean disabledSelected;


    /**
     * 用于存放显示和隐藏回填参数
     */
    private List<Map<String, Object>> fields;

    /**
     * 是否启用刷新界面
     * true开启，需要刷新界面，
     * false不开启，不刷新（默认为不开启）
     */
    private Boolean enableReload;

    /**
     * enableToolShow 是否显示在页签上
     * true 显示
     * false 不显示（不配置时默认为不显示）
     */
    private Boolean enableToolShow;

    /**
     * 是否开启自由新增行（默认开启，为false时关闭）
     */
    private Boolean openFreedomAddRow;

    /**
     * navigateTarget---跳转列
     * 该字段为array，支持指向多个字段
     * 如果是所有列支持跳转，该字段为array[0]配置成"all"
     */
    private List<String> navigateTarget;

    private List<PcUiBotTmTab> tabs;

    /**
     * 子页签（子单身）是否可以数据翻页（上一页、下一页）,
     */
    private Boolean switchData;

    /**
     * 是否是主按钮；允许有多个主按钮；默认false
     */
    private Boolean isMainButton;

    /**
     * 是否为整单操作：
     * true是，false否(不配或默认为false)
     */
    private Boolean isToolBar;

    /**
     * 复制操作的相关配置
     */
    private List<PcUiBotCopyOperationConfig> copyConfigs;

    /**
     * 默认为true
     *
     * @return
     */
    public Boolean getSwitchData() {
        return switchData == null || switchData;
    }
}
