package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.mobile.mobileuibot.designer.uibot.page.ScoredFieldsSummary;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import lombok.Data;
import org.springframework.util.ObjectUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：鼎捷雅典娜PC UI Bot页面的显示逻辑定义</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotPageDefine
 * @Author: Zaregoto
 * @Date: 2023/2/27 14:55
 */
@Data
public class PcUiBotPageDefine implements Serializable {

    private static final long serialVersionUID = -9184020267295701282L;
    /**
     * 执行上下文
     */
    private PcUiBotExecuteContext executeContext;

    /**
     * 区域块的标题
     */
    private String title;
    /**
     * 子标题
     */
    private String subTitle;
    /**
     * 描述
     */
    private String description;
    /**
     * 子描述
     */
    private String subDescription;
    /**
     * 图标
     */
    private String icon;

    /**
     * 多页面默认显示哪部分
     */
    private boolean defaultShow;
    private PcUiBotTmDataFilter dataFilter;
    /**
     * 主键,对应 TmDataState 的code,必须与TmDataState的Code相同
     */
    private String dataStateCode;

    /**
     * 数据状态个数
     */
    private int dataStateCount;

    /**
     * 查询的数据源
     */
    private PcUiBotDataSourceSetDTO dataSourceSet;

    /**
     * 查询的数据源
     */
    private PcUiBotDataSourceSetDTO allDataSourceSet;

    /**
     * 如果有参数类型为ACTIVE_ROW，则需要前端传入参数值，由后端查询时替换
     */
    private Map<String, Object> parameter;
    /**
     * 是否启用分页
     */
    private Boolean useHasNext;
    /**
     * 分页查询参数
     * pageInfo:{
     * "hasNext": true,
     * "pageNo": 1,
     * "pageSize": 50,
     * "totalResults": 134
     * }
     */
    private PcUiBotPageInfo pageInfo;
    /**
     * 排序
     * sortInfo：[
     * {
     * "schema": "requisitions_seq",
     * "orderType": "asc",
     * "order": 1
     * }
     * ]
     */
    private JSONArray sortInfo;
    /**
     * 通用过滤
     * "search_info": [
     * {
     * "search_field": "name",
     * "search_operator": "equal",
     * "search_value": "印表機"
     * },
     * {
     * "search_field": "status",
     * "search_operator": "equal",
     * "search_value": "生效"
     * }
     * ]
     */
    private List<Map> searchInfo;

    /**
     * 用户自定义信息
     */
    private JSONObject userSetting;

    /**
     * 标签增强
     */
    private List<PcUiBotDataTag> dataTags;

    private List<PcUiBotTmActivityStates> taskStates;

    /**
     * 查询tag固定后缀
     */
    private String queryTagSuffix;

    /**
     * 提交的逻辑，包括分批
     */
    private PcUiBotSubmitType submitType;

    /**
     * 是否合并多选框（针对合并行）
     */
    private Boolean multipleSelectMerge;
    /**
     * 提交按钮 ACTION
     */
    private List<PcUiBotSubmitAction> submitActions;

    /**
     * 是否显示submitActions，默认为true，如果null也是显示true
     * 目前只有客制会用到
     */
    private Boolean showSubmitActions;

    /**
     * 页面操作方式
     */
    private List<PcUiBotOperationDTO> operations = Lists.newArrayList();

    /**
     * 分组 支持 treeTable 的样式
     */
    private JSONObject settings;

    /**
     * 扩展字段
     */
    private Map<String, Object> extendedFields;

    /**
     * 状态标记statusFlag(true、false)，默认没有配置时为false;
     * a、当配置这个状态标记(true)的时候，将变化的数据返回给API，并且打上标记（add、edit、del）——只传变化的数据给API；
     * b、当没有配置这个状态标记(false)时；将界面上全部数据传给API。——将界面上看到的全部数据传给API
     */
    private Boolean statusFlag;

//    /**
//     * 树
//     */
//    private TreeConfigDTO treeConfigDTO;

//    /**
//     * 栅格配置
//     */
//    private GridConfigDTO gridConfigDTO;

    /**
     * 用户自定义字段相关属性
     */
    @JsonIgnore
    @JSONField(serialize = false)
    private List<PcUiBotUserDefinedCenterMetadataResult> userDefinedCenterMetadataResultList;

    /**
     * 根据标签来执行
     */
    private PcUiBotRelationTag relationTag;

    /**
     * 词库，如：控制表格列的显示与隐藏
     */
    private List<PcUiBotTmWordCapability> wordCapability;

    /**
     * 全局控制页面是否可以编辑,如果是null，则根据tag或者各builder来控制，否则全局控制。
     */
    private Boolean canEdit;

    /**
     * 透传数据源定义到前端
     */
    Map<String, PcUiBotTmQueryAction> dataSources;

    /**
     * 开窗中，标示【主数据来源】数据的字段名称
     */
    private String primaryField;
//
//    /**
//     * 页面控件和布局，用于存放低代码设计界面的DSL布局和组件
//     */
//    @JsonIgnore
//    @JSONField(serialize = false)
//    private List<AbstractComponent> layout;
//
//    /**
//     * 用于存于界面设计器中开窗的DSL
//     */
//    @JsonIgnore
//    @JSONField(serialize = false)
//    private List<Object> layoutObj;
//
    /**
     * 页面规则，用于存放低代码设计界面的DSL规则
     */
    @JsonIgnore
    @JSONField(serialize = false)
    private List<Map<String, Object>> rules = new ArrayList<>();

    /**
     * 页面hooks,用于切面
     */
    private List<Map<String, Object>> hooks;

    /**
     * 显示字段
     */
    private List<String> showDataProperties;

    /**
     * 词库返回的字段内容
     */
    private List<ScoredFieldsSummary> showMetadatas;

    /**
     * true:使用虚拟滚动，false/不存在使用默认分页方式
     */
    private Boolean enableVirtualScrolling;
    /**
     * true：所有数据全选 false或者不存在，则使用当前页全选
     */
    private Boolean enableSelectAll;
//
//    /**
//     * 表格过滤配置信息
//     */
//    private FilterConfigDTO filterInfo;

    /**
     * 分页是否启用后端分页true：使用后端  false或者为null。使用前端分页
     */
    private Boolean enableBackEndPaging;

    /**
     * 分页是否启用后端分页true限制，开启限制后，将只有web端支持后端分页
     */
    private Boolean enableBackEndPagingLimit;

    /**
     * 判断是否开启服务端筛选
     */
    private Boolean enableFilter;

    /**
     * 启用分页
     */
    private Boolean enablePaging;

//    /**
//     * 表格设定，如：已选中状态栏
//     */
//    private List<GridSetting> gridSettings;

    /**
     * 用于存放客制规则
     */
    private Map<String, Object> mechnismConfig;

    /**
     * 基础资料作业的说明
     */
    private String explanation;

    /**
     * 是否自动追加"已搁置"页签
     * true：追加
     * false：不追加
     * 默认true
     */
    private Boolean autoAppendShelvedDataState = Boolean.TRUE;

    /**
     * 页签配置
     */
    private List<PcUiBotTmTab> tabs = Lists.newArrayList();

    /**
     * 绑定表单信息
     */
    private PcUiBotTmFormInfo bindForm;

    /**
     * 字段权限的配置
     */
    private List<Map<String, List<PcUiBotModelField>>> fieldConfig;

    /**
     * 是否使用dataSourceName做为M
     * 默认null是false的逻辑
     * true：使用dataSourceName做为M
     * false：不使用dataSourceName做为M，保持之前逻辑不动
     */
    private Boolean masterFromDataSourceName;

//    /**
//     * 是否有用户自定义配置
//     *
//     * @return
//     */
//    public boolean hasUserDefinedConfig() {
//        return CollectionUtils.isNotEmpty(this.getUserDefinedCenterMetadataResultList());
//    }

    /**
     * 是否有用户自定义排序
     *
     * @return
     */
    public boolean hasUserSetting() {
        return CollectionUtils.isNotEmpty(this.getUserSetting());
    }

//    /**
//     * 是否为模型驱动页面
//     *
//     * @return
//     */
//    @JsonIgnore
//    public boolean isDslLayout() {
//        return CollectionUtils.isNotEmpty(this.getLayout());
//    }

    /**
     * 数据查询条件是否为空
     *
     * @return
     */
    @JsonIgnore
    public boolean dataSourceSetEmpty() {
        return dataSourceSet == null || CollectionUtils.isEmpty(dataSourceSet.getDataSourceList());
    }

    /**
     * 根据业务数据设置"是否启用分页"：有分页查询参数 且 查询结果中有下一笔，启用分页
     *
     * @param queryResultSet
     */
    @JsonIgnore
    public void resetUseHasNext(QueryResultSet queryResultSet) {
        if (this.getPageInfo() != null && queryResultSet.isMainQueryResultHasNext()) {
            this.setUseHasNext(true);
        }
    }

    @JsonIgnore
    public Map<String, PcUiBotModelField> getModelFieldMap() {
        Map<String, PcUiBotModelField> modelFieldMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(this.fieldConfig)) {
            // 暂时项目详情和任务详情取performer
            List<PcUiBotModelField> performer = this.fieldConfig.get(0).get("performer");
            flatMap(modelFieldMap, performer);
        }
        return modelFieldMap;
    }

    /**
     * 将栏位的权限进行平铺 key:path.schema  value:modelField
     */
    private void flatMap(Map<String, PcUiBotModelField> modelFieldMap, List<PcUiBotModelField> modelFieldList) {
        for (PcUiBotModelField modelField : modelFieldList) {
            String dataType = modelField.getDataType();
            if ("object".equals(dataType)) {
                List<PcUiBotModelField> fields = modelField.getFields();
                if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(fields)) {
                    flatMap(modelFieldMap, fields);
                }
            } else {
                modelFieldMap.put(getKey(modelField.getPath(), modelField.getSchema()), modelField);
            }
        }
    }

    /**
     * 唯一key 路径加schema
     */
    private String getKey(String path, String schema) {
        return path + "." + schema;
    }

    // ------------------------移动设计器新增属性--------------------------------
    /**
     * 是否显示数据状态的标题 -- 移动设计器新增属性
     * 默认true显示
     */
    private Boolean showTitle;
    /**
     * 预设页面，进入页面默认显示的数据状态code -- 移动设计器新增字段
     */
    private String defaultTabMobileCode;

    /**
     * 是否显示单头
     */
    private Boolean showSingleHeadFrom;

    /**
     * 移动页面控件和布局
     */
    private List<UiBotPageLayout> pageLayout;
    /**
     * 移动任务提示配置
     */
    private UiBotTipSetting tipSetting;
    /**
     * 是否设计过移动DSL，主要用来判断走什么页面构建策略
     */
    private Boolean isDesignerDsl;


    /**
     *  获取主页面所有的pageID和数据源
     * @return
     */
    public Map<String, Map<String, Object>> getPageLayoutInfo(){
        Map<String, Map<String, Object>> pageLayoutInfo = new HashMap(2);
        if (ObjectUtils.isEmpty(pageLayout)) {
            return new HashMap<>();
        }
        for(UiBotPageLayout layout:this.pageLayout){
            if(ObjectUtils.isEmpty(layout.getPageId())){
                continue;
            }
            HashMap<String, Object> map = new HashMap<>(2);
            map.put("dataSource",layout.getDataSource());
            map.put("node",layout.getNode());
            map.put("nodePath",layout.getNodePath());
            pageLayoutInfo.put(layout.getPageId(),map);
        }
        return pageLayoutInfo;
    }


}
